<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class CleanupSpamIps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'spam:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up old spam IP records and expired cache entries';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting spam IP cleanup...');

        // Clean up old spam IP records (older than 7 days)
        $cleaned = 0;
        
        // Note: In a production environment, you might want to store spam IPs in a database
        // For now, we'll rely on Cache TTL to automatically clean up
        
        $this->info("Spam IP cleanup completed. {$cleaned} records cleaned.");
        
        // Log the cleanup
        Log::info('Spam IP cleanup completed', ['cleaned_count' => $cleaned]);
        
        return 0;
    }
}
