<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\PageSetting;
use Symfony\Component\HttpFoundation\Response;

class CheckPageProtection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Skip password protection check for password entry routes to avoid infinite redirect
        if ($request->routeIs('page.password.entry') || $request->routeIs('page.password.verify')) {
            return $next($request);
        }
        
        $pageUrl = $request->getPathInfo();
        $pageSetting = PageSetting::where('page_url', $pageUrl)->first();
        
        if ($pageSetting && $pageSetting->is_protected) {
            $verificationTime = session()->get('page_verified_time_' . $pageSetting->id);
            
            if (!$verificationTime || now()->diffInHours($verificationTime) > 24) {
                session()->forget('page_verified_' . $pageSetting->id);
                session()->forget('page_verified_time_' . $pageSetting->id);
                
                // Store page ID in session for password entry
                session()->put('protected_page_id', $pageSetting->id);
                
                return redirect()->route('page.password.entry');
            }
        }
        
        return $next($request);
    }
}
