<?php

namespace App\Jobs;

use App\Models\Stock;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class FetchStockData implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $url = 'https://www.stockexchangeofmauritius.com/shareprice/pbl/pblquotes.xml';

        try {

            $response = Http::get($url);
            if ($response->successful()) {
                $xml = simplexml_load_string($response->body());

                $timestamp = (string) $xml->timestamp;
                $date = (string) $xml->timestamp->date;
                $price = (float) $xml->quote->sharepprice;
                $semdex = (float) $xml->quote->semdex;

                $dateTime = \DateTime::createFromFormat('d-M-Y', $date);
                if ($dateTime) {
                    $formattedDate = $dateTime->format('Y-m-d');

                    Stock::create([
                        'date' => $formattedDate,
                        'closing_price' => $price,
                    ]);
                } else {
                    Log::info("Invalid date format: $date");
                }
                Log::info("Stock data for {$date} inserted successfully.");
            } else {
                Log::error('Failed to fetch stock data from the API.');
            }
        } catch (\Exception $e) {
            Log::error('Error occurred while fetching stock data: ' . $e->getMessage());
        }
    }
}
