<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ContactFormMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $full_name;
    public $email;
    public $caseId;
    public $message;
    public $adminEmail;

    public function __construct($contactData, $adminEmail=null)
    {
        $this->full_name = $contactData['full_name'];
        $this->email = $contactData['email'];
        $this->caseId = $contactData['contact_form_id'];
        $this->message = $contactData['message'];
        $this->adminEmail = $adminEmail;

    }


    public function build()
    {
        $subject = 'New Contact Form Submission - ' . $this->caseId;
        $body = $this->message;

        if ($this->adminEmail) {
            return $this->subject($subject)
                ->view('emails.AdminContactForm')
                ->with([
                    'full_name' => $this->full_name,
                    'email' => $this->email,
                    'body' => $body,
                    'caseId' => $this->caseId,
                ]);
        } else {
            return $this->subject($subject)
                ->view('emails.contactForm')
                ->with([
                    'full_name' => $this->full_name,
                    'email' => $this->email,
                    'message' => $this->message,
                    'caseId' => $this->caseId,
                ]);
        }
    }

    // public function build()
    // {
    //     return $this->subject('New Contact Form Submission - ' . $this->caseId)
    //                 ->view('emails.contactForm');
    // }
}
