@extends('layouts.app')
<style>
    /* Honeypot field styling - completely hidden */
    .honeypot-field {
        position: absolute !important;
        left: -9999px !important;
        top: -9999px !important;
        width: 1px !important;
        height: 1px !important;
        opacity: 0 !important;
        pointer-events: none !important;
        z-index: -1 !important;
    }

    /* Form field wrapper for proper error message placement */
    .form-field-wrapper {
        margin-bottom: 15px;
        width: 100%;
    }

    .form-field-wrapper:last-child {
        margin-bottom: 0;
    }

    /* Error message styling */
    .error-message {
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 5px;
        display: none;
        line-height: 1.4;
    }

    .error-message:not(:empty) {
        display: block;
    }

    /* Invalid field styling */
    .form-control.is-invalid {
        border-color: #dc3545;
        padding-right: calc(1.5em + 0.75rem);
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath d='m5.8 3.6 .4.4.4-.4m0 4.8-.4-.4-.4.4'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right calc(0.375em + 0.1875rem) center;
        background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
    }

    .form-control.is-valid {
        border-color: #28a745;
    }

    /* Form Loader Styles */
    .form-loader {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-left: 15px;
    }

    .spinner-container {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        position: relative;
        width: 40px;
        height: 40px;
    }

    .spinner-ring {
        position: absolute;
        width: 100%;
        height: 100%;
        border: 3px solid transparent;
        border-top-color: #08BABB;
        border-radius: 50%;
        animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
    }

    .spinner-ring:nth-child(1) {
        animation-delay: -0.45s;
        border-top-color: #08BABB;
    }

    .spinner-ring:nth-child(2) {
        animation-delay: -0.3s;
        border-top-color: rgba(8, 186, 187, 0.7);
        width: 80%;
        height: 80%;
        top: 10%;
        left: 10%;
    }

    .spinner-ring:nth-child(3) {
        animation-delay: -0.15s;
        border-top-color: rgba(8, 186, 187, 0.5);
        width: 60%;
        height: 60%;
        top: 20%;
        left: 20%;
    }

    .spinner-ring:nth-child(4) {
        border-top-color: rgba(8, 186, 187, 0.3);
        width: 40%;
        height: 40%;
        top: 30%;
        left: 30%;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    .loader-text {
        color: #08BABB;
        font-size: 0.9rem;
        font-weight: 500;
        white-space: nowrap;
    }

    /* Disable button during submission */
    #submit-button:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }
</style>
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/careers/08_careers_pbl.png') }});">
        </div>
        <div class="page-title-container">
            <h4>CAREERS</h4>
            <span class="text-primary">Your Pathway to Success.</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row pb-6">
            <div class="col-lg-6 col-md-12 py-3 px-4" data-aos="fade-right" data-aos-delay="1000">
                <h3>Careers at Phoenix Beverages Group</h3>
                <p class="text-wrap our-holding-location" style="text-align: justify">
                    We aim to recruit high calibre people who will take ownership of challenges and revel in finding
                    solutions to problems.
                    We look for people who work well individually and, just as well, collectively to deliver exceptional
                    results.
                    We nurture people who are generous in their sharing of ideas and passionate about delivering quality to
                    our customers and our consumers.
                </p>

                <p class="text-wrap our-holding-location" style="text-align: justify">
                    Although each of Phoenix Beverages Group departments has its own culture, each member of the company is
                    united around the Thirst for the Best, First for You motto.
                    If you are looking for a challenging role in our organization we invite you to browse through what our
                    departments have to offer.
                </p>
            </div>

            <div class="col-lg-6 col-md-12 px-5" data-aos="fade-left" data-aos-delay="1000">

                <div class="overview-image bg-image pbg-shadow "
                    style="background-image: url({{ asset('images/careers/phoenixbev_operations.png') }})">

                </div>
            </div>
        </div>
    </div>
    </div>


    <div class="main-section py-6 px-3">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 py-3 px-4" data-aos="fade-right" data-aos-delay="1000">
                    <h3>Why Work for us</h3>
                    <p class="text-wrap our-holding-location" style="text-align: justify">
                        At Phoenix Beverages Group, our employees are rewarded for their hard work and dedication and they
                        enjoy competitive pay and excellent benefits, along with a positive work environment built on mutual
                        respect and professionalism.
                        Taking care of our employees is a must as we understand that they are the driving force behind our
                        success.
                    </p>
                    <p class="text-wrap our-holding-location" style="text-align: justify">
                        Our values – customer orientation, innovation, adaptability, honesty and trustworthiness - are
                        detailed in a Code of Ethics that encourages living them with integrity and in compliance with the
                        law.
                        This Code of Ethics, signed by employees, defines the Group's commitments towards both our
                        stakeholders and the environment. It also states the fair and transparent behaviour that we promote
                        amongst ourselves while fulfilling those commitments.
                    </p>
                </div>
                <div class="col-lg-6 col-md-12" data-aos="fade-left" data-aos-delay="1000">
                    <form id="careers-form">
                        @csrf
                        <input type="hidden" name="form_start_time" value="{{ time() }}">

                        <!-- Honeypot fields - hidden from users but visible to bots -->
                        <div class="honeypot-field" aria-hidden="true">
                            <input type="text" name="hp_website" tabindex="-1" autocomplete="nope">
                            <input type="text" name="hp_url" tabindex="-1" autocomplete="nope">
                            <input type="text" name="hp_company" tabindex="-1" autocomplete="nope">
                            <input type="text" name="hp_subject" tabindex="-1" autocomplete="nope">
                        </div>


                        <div class="custom-form-group">
                            <div class="form-field-wrapper">
                                <input type="text" class="form-control" placeholder="Full Name" name="full_name"
                                    value="{{ old('full_name') }}" required minlength="3" maxlength="50">
                                <div class="error-message" id="error-full_name"></div>
                                @error('full_name')
                                    <div class="error-message" style="display: block;">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-field-wrapper">
                                <input type="email" class="form-control" placeholder="Email" name="email"
                                    value="{{ old('email') }}" required>
                                <div class="error-message" id="error-email"></div>
                                @error('email')
                                    <div class="error-message" style="display: block;">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="custom-form-group">
                            <div class="form-field-wrapper">
                                <input type="text" class="form-control" placeholder="Phone Number" name="phone_number"
                                    value="{{ old('phone_number') }}" required minlength="10" maxlength="20">
                                <div class="error-message" id="error-phone_number"></div>
                                @error('phone_number')
                                    <div class="error-message" style="display: block;">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-field-wrapper">
                                <input type="file" class="form-control" placeholder="Upload CV (PDF only)"
                                    name="cv" value="{{ old('cv') }}" required accept=".pdf,application/pdf">
                                <div class="error-message" id="error-cv"></div>
                                @error('cv')
                                    <div class="error-message" style="display: block;">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-field-wrapper">
                            <textarea class="form-control" name="message" placeholder="Message" rows="7" required minlength="10"
                                maxlength="1000">{{ old('message') }}</textarea>
                            <div class="error-message" id="error-message"></div>
                            @error('message')
                                <div class="error-message" style="display: block;">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="cta d-flex justify-content-between align-items-center">
                            <div class="h-captcha" data-sitekey="{{ config('services.hcaptcha.secret') }}"></div>
                            <div class="d-flex align-items-center">
                                <input type="button" class="button pbg-button pbg-shadow" id="submit-button"
                                    value="Submit" />
                                <div id="loading-spinner" class="form-loader" style="display: none;">
                                    <div class="spinner-container">
                                        <div class="spinner-ring"></div>
                                        <div class="spinner-ring"></div>
                                        <div class="spinner-ring"></div>
                                        <div class="spinner-ring"></div>
                                    </div>
                                    {{-- <span class="loader-text">Submitting...</span> --}}
                                </div>
                            </div>
                        </div>
                        <div class="show-alert" style="display: none">
                            <span class="alert-icon">&#x2714;</span>
                            <span class="alert-text text-smaller">Your submission was successful!</span>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>

    <div class="page-blue" style="height: 50px"></div>

@stop
<script src="{{ URL::asset('jquery/dist/jquery.js') }}"></script>
<script>
    var tpj = jQuery.noConflict();
    tpj(document).ready(function() {
        // Function to clear all error messages
        function clearErrorMessages() {
            tpj('.error-message').text('').hide();
            tpj('.form-control').removeClass('is-invalid is-valid');
        }

        // Function to show error message for a field
        function showFieldError(fieldName, message) {
            var errorElement = tpj('#error-' + fieldName);
            if (errorElement.length) {
                errorElement.text(message).show();
                tpj('[name="' + fieldName + '"]').addClass('is-invalid').removeClass('is-valid');
            }
        }

        // Function to clear error for a specific field
        function clearFieldError(fieldName) {
            var errorElement = tpj('#error-' + fieldName);
            if (errorElement.length) {
                errorElement.text('').hide();
                tpj('[name="' + fieldName + '"]').removeClass('is-invalid').addClass('is-valid');
            }
        }

        tpj("#careers-form").validate({
            rules: {
                full_name: {
                    required: true,
                    minlength: 3
                },
                email: {
                    required: true,
                    email: true
                },
                message: {
                    required: true,
                    minlength: 10
                },
                phone_number: {
                    required: true,
                    minlength: 11
                },
                cv: {
                    required: true
                }
            },
            messages: {
                full_name: {
                    required: "Please enter your name",
                    minlength: "Your name must be at least 3 characters long"
                },
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                },
                message: {
                    required: "Please enter your message",
                    minlength: "Your message must be at least 10 characters long"
                },
                phone_number: {
                    required: "Please enter your phone number",
                    minlength: "Phone number must be at least 11 characters long"
                },
                cv: {
                    required: "Please upload your CV"
                }
            },
            errorPlacement: function(error, element) {
                var fieldName = element.attr('name');
                var errorMessage = error.text();
                showFieldError(fieldName, errorMessage);
                error.remove(); // Remove default error placement
            },
            success: function(label, element) {
                var fieldName = tpj(element).attr('name');
                clearFieldError(fieldName);
            },
            highlight: function(element) {
                tpj(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element) {
                tpj(element).removeClass('is-invalid').addClass('is-valid');
            }
        });

        tpj("#submit-button").on('click', function(event) {
            event.preventDefault();

            // Clear previous error messages
            clearErrorMessages();

            // Prevent rapid submissions
            if (tpj("#submit-button").prop('disabled')) {
                return;
            }

            // Validate form
            if (!tpj("#careers-form").valid()) {
                return;
            }

            // If validation passes, proceed with submission
            // Check if form was filled too quickly (less than 3 seconds)
            var formStartTime = tpj('input[name="form_start_time"]').val();
            var currentTime = Math.floor(Date.now() / 1000);
            var timeDiff = currentTime - formStartTime;

            if (timeDiff < 3) {
                tpj(".show-alert")
                    .removeClass("success")
                    .addClass("error")
                    .find(".alert-icon")
                    .html("&#10060;")
                    .end()
                    .find(".alert-text")
                    .text("Please take your time to fill out the form properly.")
                    .end()
                    .show();
                return;
            }

            // Validate file type (PDF only)
            var cvFile = tpj('input[name="cv"]')[0].files[0];
            if (cvFile) {
                var fileExtension = cvFile.name.split('.').pop().toLowerCase();
                var fileType = cvFile.type;

                if (fileExtension !== 'pdf' && fileType !== 'application/pdf') {
                    tpj(".show-alert")
                        .removeClass("success")
                        .addClass("error")
                        .find(".alert-icon")
                        .html("&#10060;")
                        .end()
                        .find(".alert-text")
                        .text("Please upload a PDF file only.")
                        .end()
                        .show();
                    return;
                }
            }

            var hcaptchaResponse = grecaptcha.getResponse();

            if (hcaptchaResponse === "") {
                tpj(".show-alert")
                    .removeClass("success")
                    .addClass("error")
                    .find(".alert-icon")
                    .html("&#10060;")
                    .end()
                    .find(".alert-text")
                    .text("Please complete the reCAPTCHA.")
                    .end()
                    .show();
                return;
            }

            // Disable button and show loader
            $("#submit-button").prop("disabled", true);
            $("#loading-spinner").fadeIn(300);

            // Create FormData object
            var formData = new FormData(tpj("#careers-form")[0]);
            formData.append('h-recaptcha-response', hcaptchaResponse);

            $.ajax({
                url: "{{ route('submit.careers') }}",
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    $("#loading-spinner").fadeOut(300);
                    $("#submit-button").val("Submit");
                    clearErrorMessages();
                    if (response.status === 'success') {
                        const caseId = response.data;
                        tpj(".show-alert")
                            .removeClass("error")
                            .addClass("success")
                            .find(".alert-icon")
                            .html("&#x2714;")
                            .end()
                            .find(".alert-text")
                            .text(`Your submission was successful! case id : ${caseId} `)
                            .end()
                            .show();
                    } else {
                        $(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    }

                    tpj("#careers-form")[0].reset();
                    grecaptcha.reset();
                },
                error: function(xhr, status, error) {
                    tpj("#loading-spinner").fadeOut(300);
                    tpj("#submit-button").val("Submit");
                    clearErrorMessages();

                    // Handle validation errors from Laravel
                    if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                        var errors = xhr.responseJSON.errors;
                        tpj.each(errors, function(field, messages) {
                            if (messages && messages.length > 0) {
                                showFieldError(field, messages[0]);
                            }
                        });

                        // Show general error message
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Please correct the errors in the form.")
                            .end()
                            .show();
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        // Show specific error message from server
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text(xhr.responseJSON.message)
                            .end()
                            .show();
                    } else {
                        // Generic error
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    }
                },
                complete: function() {
                    $("#submit-button").prop("disabled", false).val("Submit");
                }
            });
        });
    });


    tpj(document).on('click', '.alert .close', function() {
        tpj(this).parent().hide();
    });
</script>
