<!DOCTYPE html>
<html>
<head>
    <title>New Career Application</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: #08BABB;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .content {
            padding: 20px;
            background: #f9f9f9;
        }
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>New Career Application</h2>
            <p>Case ID: {{ $data['case_id'] }}</p>
        </div>
        
        <div class="content">
            <p><strong>Applicant Details:</strong></p>
            <ul>
                <li><strong>Name:</strong> {{ $data['full_name'] }}</li>
                <li><strong>Email:</strong> {{ $data['email'] }}</li>
                <li><strong>Phone:</strong> {{ $data['phone_number'] }}</li>
            </ul>

            <p><strong>Message:</strong></p>
            <p>{{ $data['message'] }}</p>

            @if($data['cv_path'])
            <p><strong>CV:</strong> The applicant's CV has been uploaded to the server.</p>
            @endif
        </div>

        <div class="footer">
            <p>This is an automated message from Phoenix Beverages Group Careers Portal.</p>
            <p>Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html> 