@extends('layouts.app')
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/shareholders/cover.png') }});">
        </div>
        <div class="page-title-container">
            <h4>The Shareholders
                <br>Powering Our Growth
            </h4>
        </div>
    </div>

    <div class="container landing-section pb-4" style="width: 80%;">
        <div class="row mb-2">
            <div class="col-lg-8 col-md-12 mb-4 px-2">
                <div class="mx-2">
                    <p style="color: #08BABB" data-aos="fade-down" data-aos-delay="500">Breakdown</p>
                    <h4 class="w-75" data-aos="fade-down" data-aos-delay="500">Shareholder’s Information</h4>
                    <p class="smallest-text" style="text-align: justify;" data-aos="fade-down" data-aos-delay="500">
                        Phoenix Beverages Group has consistently delivered strong returns to its shareholders over the past
                        decade. By investing in the company,
                        shareholders have benefited from:
                        <br>
                        <b>Capital Appreciation, Regular Dividends, and Solid Holding Period Returns. </b>
                    </p>
                    <div class="table-responsive" data-aos="fade-right" data-aos-delay="500">
                        <table class="table shareholders-table">
                            <tbody>
                                <tr>
                                    <td rowspan="2" width="263"></td>
                                    <td colspan="2" width="196" style="background-color:#08BABB">Year 2024</td>
                                    <td colspan="2" width="234">10 years period<br>
                                        (2015-2024)</td>
                                </tr>
                                <tr>
                                    <td>MUR</td>
                                    <td>%</td>
                                    <td style="background-color:#344552">MUR</td>
                                    <td width="122" style="background-color:#344552">Annualised<br>
                                        %</td>
                                </tr>
                                <tr>
                                    <td>Capital appreciation</td>
                                    <td>(40.00)</td>
                                    <td>7.55</td>
                                    <td>295.00</td>
                                    <td>9.65</td>
                                </tr>
                                <tr>
                                    <td>Dividend received</td>
                                    <td>22.40</td>
                                    <td>4.23</td>
                                    <td>130.35</td>
                                    <td>2.62</td>
                                </tr>
                                <tr>
                                    <td>Holding period return</td>
                                    <td>(17.60)</td>
                                    <td>(3.32)</td>
                                    <td>425.35</td>
                                    <td>12.27</td>
                                </tr>
                            </tbody>

                        </table>
                    </div>
                </div>

            </div>
            <div class="col-lg-4 col-md-12 mb-4 px-2" style="align-item:center;margin-top:10%;" data-aos="fade-left" data-aos-delay="500">
                <div class="card mx-3 pl-4 investor-relations-dark py-3">
                    <div class="card-body">
                        <img src="{{ asset('images/shareholders/pbg-log.png') }}" alt="pbg-logo" width="200"
                            height="100" style="object-fit: contain" />
                        <h4>Stock Information</h4>
                        <p>
                            MBL.N0000 <span class="stock-value">{{ $stockInfo['current_price'] }}</span> {{ $stockInfo['percentage_change'] }}%
                            <br>
                            <span style="color: rgba(255, 255, 255, 0.53);;">{{ $stockInfo['last_updated'] }}</span>
                        </p>

                        <h4><span class="stock-value text-white">{{ $stockInfo['current_price'] }}</span> <span
                                style="font-size: 14px; color:#ffffff"><sub>MUR</sub></span></h4>

                        <span
                            class="{{ $stockInfo['is_positive'] ? 'green-caret' : 'red-caret' }}">{{ $stockInfo['price_change'] }}
                            ({{ $stockInfo['percentage_change'] }}%)
                        </span>

                    </div>
                </div>
            </div>
        </div>

    </div>


    </div>


    <div class="main-section">
        <div class="container">
            <div class="pt-6 pb-4">
                <h4 class="mx-auto" style="text-align:center;" data-aos="fade-down" data-aos-delay="500">
                    Main Shareholders of Phoenix <br> Beverages Group
                </h4>
            </div>

            <div style="display: flex; justify-content: space-around;" class="pb-5" style="overflow-x: auto;">
                <div data-aos="fade-down" data-aos-delay="500">
                    <h6 class="text-center">
                        IBL Ltd <br>
                        3.21%
                    </h6>
                    <canvas id="doughnutChart1" width="150" height="100"></canvas>
                </div>
                <div data-aos="fade-down" data-aos-delay="600"> 
                    <h6 class="text-center">
                        Camp Investment Company Ltd <br>
                        17.06%
                    </h6>
                    <canvas id="doughnutChart2" width="150" height="100"></canvas>
                </div>
                <div data-aos="fade-down" data-aos-delay="700">
                    <h6 class="text-center">
                        Phoenix Investment Company Ltd <br>
                        31.02%
                    </h6>
                    <canvas id="doughnutChart3"></canvas>
                </div>
                {{-- <div>
                    <h6 class="text-center">
                        Novac Holdings Ltd <br>
                        10.62%
                    </h6>
                    <canvas id="doughnutChart4" width="150" height="100"></canvas>
                </div> --}}
            </div>
        </div>

    </div>

    <div class="page-blue py-6 px-3">
        <div class="container">
            <h3 class="text-center py-5" data-aos="fade-down" data-aos-delay="500">3-Year Share Price Trend</h3>
            <div style="display: flex; justify-content: space-between; align-items: flex-start;" >
                <div class="line-chart-container" style="flex: 7; margin-right: 20px;" data-aos="fade-right" data-aos-delay="500">
                    <canvas id="myLineChart" width="300" height="120"></canvas>
                </div>
                <div style="flex: 5;" class="pt-4" data-aos="fade-left" data-aos-delay="500">
                    <span class="" style="font-size: 14px">Market Price at Close</span>
                    <br><br>
                    <h3 style="color:#08BABB; font-weight:bold">{{ $stockInfo['current_price'] }} MUR</h3>

                    <div class="market-details">
                        <div>
                            Previous close
                        </div>
                        <div>
                            {{ $stockInfo['previous_close'] }} MUR
                        </div>

                    </div>
                    <div class="market-details">
                        <div>
                            % change
                        </div>
                        <div style="color:{{ $stockInfo['is_positive'] ? '#0ED322' : '#FF4444' }}; ">
                            {{ $stockInfo['percentage_change'] }}
                        </div>

                    </div>
                    <div class="market-details">
                        <div>
                            Earning per share
                        </div>
                        <div>
                            {{ $stockInfo['earning_per_share'] }} MUR
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 mb-4">
                <h3 class="text-center py-5" data-aos="fade-down" data-aos-delay="500">Group Key Figures</h3>

                <div class="container">
                    <div class="row">
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500">
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">TOTAL ASSETS</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart1"></canvas>
                            </div>
                        </div>
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500">
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">TURNOVER</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart2"></canvas>
                            </div>
                        </div>
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500">
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">OPERATING PROFITS</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart3"></canvas>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500">
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">CAPITAL INVESTMENT</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart4"></canvas>
                            </div>
                        </div>
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500">
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">SHAREHOLDERS' FUND</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart5"></canvas>
                            </div>
                        </div>
                        <div class="col-md-4" data-aos="fade-down" data-aos-delay="500"> 
                            <div class="chart-container">
                                <div style="font-weight: bold; font-size:14px;">EBITDA</div>
                                {{-- <span class="smaller-text">(Million)</span> --}}
                            </div>
                            <div class="canvas-container">
                                <canvas id="barChart6"></canvas>
                            </div>
                        </div>
                    </div>
                </div>

            </div>



        </div>
    </div>


    <script>
        document.querySelectorAll('.pill').forEach(pill => {
            pill.addEventListener('click', () => {
                document.querySelectorAll('.pill').forEach(p => p.classList.remove('active'));
                pill.classList.add('active');
            });
        });

        const percentages = [3.21, 17.06, 31.02];
        const colors = [
            'rgba(8, 186, 187, 1)', // Color for Chart 1
            'rgba(8, 186, 187, 1)', // Color for Chart 2
            'rgba(8, 186, 187, 1)', // Color for Chart 3
            // 'rgba(8, 186, 187, 1)' // Color for Chart 4
        ];

        const createDoughnutChart = (ctx, percentage, color, shareholder) => {
            const data = {
                labels: [shareholder, 'Phoenix Beverages Ltd'],
                datasets: [{
                    data: [percentage, 100 - percentage],
                    backgroundColor: [color, 'rgba(231, 233, 234, 1)'],
                    hoverOffset: 4
                }]
            };

            const config = {
                type: 'doughnut',
                data: data,
                options: {
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: (tooltipItem) => {
                                    return `${tooltipItem.label}: ${tooltipItem.raw.toFixed(2)}%`;
                                }
                            }
                        }
                    }
                }
            };

            return new Chart(ctx, config);
        };

        const ctx1 = document.getElementById('doughnutChart1').getContext('2d');
        const ctx2 = document.getElementById('doughnutChart2').getContext('2d');
        const ctx3 = document.getElementById('doughnutChart3').getContext('2d');
        // const ctx4 = document.getElementById('doughnutChart4').getContext('2d');

        createDoughnutChart(ctx1, percentages[0], colors[0], 'IBl Ltd.');
        createDoughnutChart(ctx2, percentages[1], colors[1], 'Camp Investment Company Ltd');
        createDoughnutChart(ctx3, percentages[2], colors[2], 'Phoenix Investment Company Ltd.');
        // createDoughnutChart(ctx4, percentages[3], colors[3]);



        const data = {
            labels: @json($sharePriceTrend['labels']),
            datasets: [{
                label: 'Share Price',
                data: @json($sharePriceTrend['data']),
                fill: true,
                showLine: true,
                backgroundColor: 'rgba(10, 31, 46, 1)',
                borderColor: 'rgba(75, 192, 192, 1)', // RGBA color
                tension: 0.5,
            }]
        };

        const config = {
            type: 'line',
            data: data,
            options: {
                plugins: {
                    legend: {
                        display: true, // Show the legend
                        labels: {
                            color: 'white' // Set legend label color to white
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: (tooltipItem) => {
                                return `${tooltipItem.label}: $${tooltipItem.raw}`; // Add dollar sign to tooltip
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        title: {
                            display: true,
                            color: 'white'
                        },
                        ticks: {
                            callback: (value) => `MUR ${value}`,
                            color: 'white',
                            stepSize: 5
                        },
                        grid: {
                            color: 'rgba(255, 255, 255, 0.3)'
                        }
                    },
                    x: {
                        ticks: {
                            color: 'white'
                        },
                        grid: {
                            color: 'rgba(255, 255, 255, 0.3)'
                        }
                    }
                },
                layout: {
                    padding: {
                        left: 10,
                        right: 10,
                        top: 10,
                        bottom: 10
                    }
                },
                elements: {
                    point: {
                        radius: 5
                    }
                }
            }
        };

        const myLineChart = new Chart(
            document.getElementById('myLineChart'),
            config
        );


        //barchart

        //label
        const labels = ["2023", "2024"];

        const datasets = [
            [@json($financialMetrics['total_assets']['2023']), @json($financialMetrics['total_assets']['2024'])], // Chart 1
            [@json($financialMetrics['turnover']['2023']), @json($financialMetrics['turnover']['2024'])], // Chart 2
            [@json($financialMetrics['operating_profits']['2023']), @json($financialMetrics['operating_profits']['2024'])], // Chart 3
            [@json($financialMetrics['capital_investment']['2023']), @json($financialMetrics['capital_investment']['2024'])], // Chart 4
            [@json($financialMetrics['shareholders_fund']['2023']), @json($financialMetrics['shareholders_fund']['2024'])], // Chart 5
            [@json($financialMetrics['ebitda']['2023']), @json($financialMetrics['ebitda']['2024'])] // Chart 6
        ];

        const defaultColor = 'rgba(75, 192, 192, 1)';
        const lowerBarColor = 'rgba(52, 69, 82, 1)'; // Color for the lower bar

        const chartIds = ['barChart1', 'barChart2', 'barChart3', 'barChart4', 'barChart5', 'barChart6'];

        // Create the 6 bar charts with different datasets
        chartIds.forEach((chartId, index) => {
            const data = datasets[index];

            // Determine which bar is lower and assign colors accordingly
            const barColors = data.map((value, i) => {
                return value === Math.min(...data) ? lowerBarColor : defaultColor;
            });

            const chartData = {
                labels: labels,
                datasets: [{
                    label: `Dataset ${index + 1}`,
                    data: data,
                    backgroundColor: barColors,
                    borderColor: barColors.map(color => color.replace('0.2',
                        '1')), // Adjust border color
                    borderWidth: 1,
                    fill: true,
                    showLine: true,
                    barThickness: 50
                }]
            };

            const config = {
                type: 'bar',
                data: chartData,
                options: {
                    layout: {
                        padding: {
                            left: 0 // Reduce left padding to bring bars closer to y-axis
                        }
                    },
                    scales: {
                        x: {
                            grid: {
                                display: false // Remove vertical grid lines
                            },
                            border: {
                                display: true,
                                color: 'rgba(255, 255, 255, 0.3)',
                                width: 1
                            },
                            ticks: {
                                padding: 5 // Add some padding between ticks and border
                            }
                        },
                        y: {
                            beginAtZero: true,
                            grid: {
                                display: false
                            },
                            border: {
                                display: true,
                                color: 'rgba(255, 255, 255, 0.3)',
                                width: 1
                            },
                            ticks: {
                                callback: function(value) {
                                    if (value >= 1e9) {
                                        return (value / 1e9).toFixed(1);
                                    } else if (value >= 1e6) {
                                        return (value / 1e6).toFixed(1);
                                    }
                                    return value;
                                },
                                padding: 5, // Add some padding between ticks and border
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        datalabels: {
                            anchor: 'center',
                            align: 'center',
                            formatter: function(value) {
                                return value >= 1e9 ? (value / 1e9).toFixed(1) + 'B' : (value / 1e6)
                                    .toFixed(1) + 'M';
                            },
                            color: 'black',
                            font: {
                                weight: 'bold',
                            }
                        }
                    }
                },
                plugins: [ChartDataLabels]
            };

            new Chart(document.getElementById(chartId), config);
        });

        // Real-time stock information updates
        async function updateStockInfo() {
            try {
                const response = await fetch('/api/shareholders-data');
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                
                const data = await response.json();
                const stockInfo = data.stock_info;
                
                // Update stock price display
                const stockValueElements = document.querySelectorAll('.stock-value');
                stockValueElements.forEach(element => {
                    element.textContent = stockInfo.current_price;
                });
                
                // Update percentage change in card
                const stockInfoParagraph = document.querySelector('.card-body p');
                if (stockInfoParagraph) {
                    const stockValueSpan = stockInfoParagraph.querySelector('.stock-value');
                    const percentageSpan = stockInfoParagraph.childNodes[2]; // The text node after the stock value
                    if (stockValueSpan) {
                        stockValueSpan.textContent = stockInfo.current_price;
                    }
                    if (percentageSpan && percentageSpan.nodeType === Node.TEXT_NODE) {
                        percentageSpan.textContent = ' ' + stockInfo.percentage_change + '%';
                    }
                }
                
                // Update price change display
                const priceChangeElement = document.querySelector('.card-body span:last-child');
                if (priceChangeElement) {
                    priceChangeElement.textContent = `${stockInfo.price_change} (${stockInfo.percentage_change})`;
                    priceChangeElement.className = stockInfo.is_positive ? 'green-caret' : 'red-caret';
                }
                
                // Update market details section
                const marketPriceElement = document.querySelector('h3[style*="color:#08BABB"]');
                if (marketPriceElement) {
                    marketPriceElement.textContent = stockInfo.current_price + ' MUR';
                }
                
                // Update previous close
                const previousCloseElements = document.querySelectorAll('.market-details div:last-child');
                if (previousCloseElements.length >= 1) {
                    previousCloseElements[0].textContent = stockInfo.previous_close + ' MUR';
                }
                
                // Update percentage change in market details
                if (previousCloseElements.length >= 2) {
                    previousCloseElements[1].textContent = stockInfo.percentage_change;
                    previousCloseElements[1].style.color = stockInfo.is_positive ? '#0ED322' : '#FF4444';
                }
                
                // Update earning per share
                if (previousCloseElements.length >= 3) {
                    previousCloseElements[2].textContent = stockInfo.earning_per_share + ' MUR';
                }
                
            } catch (error) {
                console.error('Error updating stock info:', error);
            }
        }

        // Update stock information every 5 minutes
        setInterval(updateStockInfo, 300000);
        
        // Initial update after 30 seconds
        setTimeout(updateStockInfo, 30000);
    </script>

@stop
