<style>
    .our-reach-container {
        background: url('images/our-reach/reach-cover.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        width: 100%;
        height: 100%;
    }

    /* Mobile Responsive Styles */
    @media (max-width: 768px) {
        .text-wrap {
            width: 100% !important;
            padding: 0 15px;
        }

        .landing-section h2 {
            font-size: 1.5rem !important;
            line-height: 1.4;
        }

        .landing-section .col-lg-6 {
            padding-left: 15px !important;
            padding-right: 15px !important;
            margin-bottom: 20px;
        }

        .landing-section p {
            padding-left: 0 !important;
            padding-right: 0 !important;
            text-align: justify;
        }

        #chartdiv {
            height: 70vh !important;
            min-height: 500px;
            margin: 0 10px;
        }

        .chart-container-wrapper {
            padding: 0 10px;
        }
    }

    @media (max-width: 576px) {
        .landing-section h2 {
            font-size: 1.25rem !important;
        }

        #chartdiv {
            height: 60vh !important;
            min-height: 400px;
            margin: 0 5px;
        }

        .page-title-container h4 {
            font-size: 1.5rem;
        }
    }
</style>

<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/our-reach/our-reach-cover.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>OUR REACH</h4>
            <span class="text-primary">An Enriching Journey</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="text-wrap mx-auto" style="width: 80%">
            <h2 class="text-lg text-center" data-aos="fade-down" data-aos-delay="100">
                Dedicated and Passionate to Reach <br class="d-none d-md-block">
                New Horizons
            </h2>
            <br>
            <div class="row">
                <div class="col-lg-6 col-md-12" data-aos="fade-right" data-aos-delay="100">
                    <p class="text-justify" style="padding-right: 20px">
                        It has been 22 years since Phoenix Beverages Group exported its first container of beer, and our journey continues with a bright future ahead.
                        Our beers have firmly established themselves in international markets, building a strong presence. The passion and dedication of
                        our International Business Units have propelled the freshness and quality of our products to exciting new horizons.
                    </p>
                </div>

                <div class="col-lg-6 col-md-12" data-aos="fade-left" data-aos-delay="100">
                    <p class="text-justify" style="padding-left: 20px">
                        Our export strategy is built on mutual trust and long-term partnerships to achieve meaningful and successful outcomes.
                        We focus on delivering optimal market execution, world-class service, and a steadfast commitment to strengthening brand equity in each market.
                        To ensure sustainable growth, we have established clear metrics for evaluating supply chain performance and implemented key parameters for continuous improvement.
                    </p>
                </div>
            </div>

        </div>

        <br>
        
    </div>

    <div class="col-md-12 text-center w-100 mx-auto chart-container-wrapper" data-aos="fade-up" data-aos-delay="100">
        <div id="chartdiv"></div>
    </div>


    

    <div class="mt-2 our-reach-container"></div>


    <!-- Styles -->
    <style>
    #chartdiv {
      width: 100%;
      height: 100vh;
      background: #282A36;
      border-radius: 8px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    /* Responsive chart height */
    @media (max-width: 768px) {
      #chartdiv {
        height: 70vh !important;
        min-height: 500px;
      }
    }

    @media (max-width: 576px) {
      #chartdiv {
        height: 60vh !important;
        min-height: 400px;
      }
    }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/map.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/geodata/worldLow.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

    <!-- Chart code -->
    <script>
    am5.ready(function() {

    // Create root element
    // https://www.amcharts.com/docs/v5/getting-started/#Root_element
    var root = am5.Root.new("chartdiv");


    // Set themes
    // https://www.amcharts.com/docs/v5/concepts/themes/
    root.setThemes([
      am5themes_Animated.new(root)
    ]);


    // Create the map chart
    // https://www.amcharts.com/docs/v5/charts/map-chart/
    var chart = root.container.children.push(am5map.MapChart.new(root, {
      panX: "translateX",
      panY: "translateY",
      projection: am5map.geoMercator(),
      wheelX: "none",
      wheelY: "none",
      pinchZoomX: "none",
      pinchZoomY: "none"
    }));

    // Responsive positioning for controls
    var isMobile = window.innerWidth <= 768;
    var cont = chart.children.push(am5.Container.new(root, {
      layout: root.horizontalLayout,
      x: isMobile ? 10 : 20,
      y: isMobile ? 10 : 40
    }));


    // Add labels and controls with responsive sizing
    var labelFontSize = isMobile ? 12 : 14;
    var mapLabel = cont.children.push(am5.Label.new(root, {
      centerY: am5.p50,
      text: "Map",
      fontSize: labelFontSize
    }));

    var switchButton = cont.children.push(am5.Button.new(root, {
      themeTags: ["switch"],
      centerY: am5.p50,
      icon: am5.Circle.new(root, {
        themeTags: ["icon"],
        radius: isMobile ? 8 : 10
      })
    }));

    switchButton.on("active", function() {
      if (!switchButton.get("active")) {
        chart.set("projection", am5map.geoMercator());
        chart.set("panX", "translateX");
        chart.set("panY", "translateY");
      }
      else {
        chart.set("projection", am5map.geoOrthographic());
        chart.set("panX", "rotateX");
        chart.set("panY", "rotateY");
      }
    });

    cont.children.push(am5.Label.new(root, {
      centerY: am5.p50,
      text: "Globe",
      fontSize: labelFontSize
    }));

    // Create main polygon series for countries
    // https://www.amcharts.com/docs/v5/charts/map-chart/map-polygon-series/
    var polygonSeries = chart.series.push(am5map.MapPolygonSeries.new(root, {
      geoJSON: am5geodata_worldLow
    }));

    polygonSeries.mapPolygons.template.setAll({
      fill: am5.color("#3C3F4C"),
      stroke: am5.color("#4A4D5A"),
      strokeWidth: 1
    });

    var graticuleSeries = chart.series.push(am5map.GraticuleSeries.new(root, {}));
    graticuleSeries.mapLines.template.setAll({
      stroke: am5.color("#4A4D5A"),
      strokeOpacity: 0.3
    });

    // Create line series for trajectory lines
    // https://www.amcharts.com/docs/v5/charts/map-chart/map-line-series/
    var lineSeries = chart.series.push(am5map.MapLineSeries.new(root, {}));
    lineSeries.mapLines.template.setAll({
      stroke: am5.color("#08BABB"),
      strokeOpacity: 0.8,
      strokeWidth: isMobile ? 1.5 : 2
    });

    // Create animated line series for moving dots
    var animatedLineSeries = chart.series.push(am5map.MapLineSeries.new(root, {}));
    animatedLineSeries.mapLines.template.setAll({
      stroke: am5.color("#08BABB"),
      strokeOpacity: 0,
      strokeWidth: 2
    });

    // destination series
    var citySeries = chart.series.push(
      am5map.MapPointSeries.new(root, {})
    );

    citySeries.bullets.push(function() {
      var circle = am5.Circle.new(root, {
        radius: isMobile ? 4 : 5,
        tooltipText: "{title}",
        tooltipY: 0,
        fill: am5.color("#08BABB"),
        stroke: root.interfaceColors.get("background"),
        strokeWidth: isMobile ? 1.5 : 2
      });

      return am5.Bullet.new(root, {
        sprite: circle
      });
    });

    // arrow series
    var arrowSeries = chart.series.push(
      am5map.MapPointSeries.new(root, {})
    );

    arrowSeries.bullets.push(function() {
      var arrowSize = isMobile ? 6 : 8;
      var arrowHeight = isMobile ? 2.5 : 3;
      var arrow = am5.Graphics.new(root, {
        fill: am5.color("#08BABB"),
        stroke: am5.color("#08BABB"),
        draw: function (display) {
          display.moveTo(0, -arrowHeight);
          display.lineTo(arrowSize, 0);
          display.lineTo(0, arrowHeight);
          display.lineTo(0, -arrowHeight);
        }
      });

      return am5.Bullet.new(root, {
        sprite: arrow
      });
    });

    // Moving arrow series for animation
    var movingArrowSeries = chart.series.push(
      am5map.MapPointSeries.new(root, {})
    );

    movingArrowSeries.bullets.push(function() {
      var arrowSize = isMobile ? 8 : 10;
      var arrowHeight = isMobile ? 3 : 4;
      var arrow = am5.Graphics.new(root, {
        fill: am5.color("#08BABB"),
        stroke: am5.color("#FFFFFF"),
        strokeWidth: isMobile ? 0.8 : 1,
        draw: function (display) {
          display.moveTo(0, -arrowHeight);
          display.lineTo(arrowSize, 0);
          display.lineTo(0, arrowHeight);
          display.lineTo(0, -arrowHeight);
        }
      });

      return am5.Bullet.new(root, {
        sprite: arrow
      });
    });

    var cities = [
      {
        id: "uk",
        title: "United Kingdom",
        geometry: { type: "Point", coordinates: [-0.1278, 51.5074] }
      },
      {
        id: "france",
        title: "France",
        geometry: { type: "Point", coordinates: [2.3522, 48.8566] }
      },
      {
        id: "djibouti",
        title: "Djibouti",
        geometry: { type: "Point", coordinates: [42.5903, 11.8251] }
      },
      {
        id: "china",
        title: "China",
        geometry: { type: "Point", coordinates: [116.4074, 39.9042] }
      },
      {
        id: "kenya",
        title: "Kenya",
        geometry: { type: "Point", coordinates: [36.8172, -1.2864] }
      },
      {
        id: "seychelles",
        title: "Seychelles",
        geometry: { type: "Point", coordinates: [55.4510, -4.6141] }
      },
      {
        id: "mayotte",
        title: "Mayotte",
        geometry: { type: "Point", coordinates: [45.2275, -12.7800] }
      },
      {
        id: "comoros",
        title: "Comoros",
        geometry: { type: "Point", coordinates: [43.2551, -11.7020] }
      },
      {
        id: "madagascar",
        title: "Madagascar",
        geometry: { type: "Point", coordinates: [47.5079, -18.8792] }
      },
      {
        id: "mauritius",
        title: "Mauritius",
        geometry: { type: "Point", coordinates: [57.5000, -20.1667] }
      },
      {
        id: "rodrigues",
        title: "Rodrigues",
        geometry: { type: "Point", coordinates: [63.4167, -19.7000] }
      },
      {
        id: "australia",
        title: "Australia",
        geometry: { type: "Point", coordinates: [151.2093, -33.8688] }
      },
      {
        id: "reunion",
        title: "Reunion Island",
        geometry: { type: "Point", coordinates: [55.448101, -20.878901] }
      }
    ];

    citySeries.data.setAll(cities);

    // prepare line series data
    var destinations = ["uk", "france", "djibouti", "china", "kenya", "seychelles", "mayotte", "comoros", "madagascar", "rodrigues", "australia", "reunion"];
    // Mauritius coordinates (Phoenix Beverages Group headquarters)
    var originLongitude = 57.5000;
    var originLatitude = -20.1667;

    am5.array.each(destinations, function (did) {
      var destinationDataItem = citySeries.getDataItemById(did);
      var lineDataItem = lineSeries.pushDataItem({ geometry: { type: "LineString", coordinates: [[originLongitude, originLatitude], [destinationDataItem.get("longitude"), destinationDataItem.get("latitude")]] } });

      arrowSeries.pushDataItem({
        lineDataItem: lineDataItem,
        positionOnLine: 0.5,
        autoRotate: true
      });

      // Add moving arrow for animation
      var movingArrow = movingArrowSeries.pushDataItem({
        lineDataItem: lineDataItem,
        positionOnLine: 0,
        autoRotate: true
      });

      // Animate the moving arrow from Mauritius toward each city (outward)
      movingArrow.animate({
        key: "positionOnLine",
        from: 0,
        to: 1,
        duration: 3000,
        easing: am5.ease.linear,
        loops: Infinity
      });
    })

    polygonSeries.events.on("datavalidated", function () {
      // Responsive zoom level
      var zoomLevel = isMobile ? 2.5 : 3;
      chart.zoomToGeoPoint({ longitude: 57.5000, latitude: -20.1667 }, zoomLevel);
    })

    // Handle window resize for responsive behavior
    window.addEventListener('resize', function() {
      if (chart && !chart.isDisposed()) {
        var newIsMobile = window.innerWidth <= 768;
        if (newIsMobile !== isMobile) {
          isMobile = newIsMobile;
          // Update zoom on resize
          chart.zoomToGeoPoint({ longitude: 57.5000, latitude: -20.1667 }, isMobile ? 2.5 : 3);
        }
      }
    });


    // Make stuff animate on load
    chart.appear(1000, 100);

    }); // end am5.ready()
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/our-reach.blade.php ENDPATH**/ ?>