<style>
    /* History Slider Styles */
    .history-slider {
        position: relative;
        background-color: #08BABB;
        border-radius: 8px;
        overflow: hidden;
    }

    /* Add a container for positioning the slides */
    .history-slides-container {
        position: relative;
        width: 100%;
        min-height: 550px; /* Ensure container has height */
    }

    .history-slide {
        /* This makes the slides stack on top of each other */
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;

        /* This handles the fade transition */
        opacity: 0;
        visibility: hidden;
        /* Make fade-out instant and fade-in quick */
        transition: visibility 0s 0.7s, opacity 0.6s ease-in-out 0.1s;

        display: flex;
        align-items: stretch;
        background-color: #08BABB;
    }

    .history-slide.active {
        opacity: 1;
        visibility: visible;
        z-index: 10;
        transition-delay: 0s;
    }

    .history-slide .slide-image {
        width: 50%;
        flex-shrink: 0;
        overflow: hidden; /* Hide parts of the image that slide out */
    }

    .history-slide .slide-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
        /* The starting position is now set by JS, but the transition is here */
        transition: transform 0.7s cubic-bezier(0.22, 1, 0.36, 1);
    }

    .history-slide.active .slide-image img {
        transform: translateX(0);
    }

    .history-slide .slide-content {
        padding: 4rem;
        color: white;
        width: 50%;
        box-sizing: border-box;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .history-slide .slide-content .year {
        font-size: 2.5rem;
        font-weight: bold;
        margin-bottom: 2rem;
    }

    .history-slide .slide-content ul {
        list-style: none;
        padding-left: 0;
    }

    .history-slide .slide-content ul li {
        margin-bottom: 1rem;
        display: flex;
        align-items: flex-start;
    }

    .history-slide .slide-content ul li::before {
        content: '';
        background-image: url("data:image/svg+xml,%3Csvg width='24' height='24' viewBox='0 0 24 24' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z' fill='white'/%3E%3C/svg%3E");
        background-size: 20px 20px;
        width: 20px;
        height: 20px;
        flex-shrink: 0;
        margin-right: 15px;
        margin-top: 2px;
    }

    .slider-nav {
        position: absolute;
        bottom: 2rem;
        left: 0;
        width: 50%; /* Span the width of the image */
        display: flex;
        justify-content: space-between;
        padding: 0 2rem; /* Add some space from the edges */
        box-sizing: border-box;
        z-index: 20;
    }

    .slider-nav button {
        background-color: rgba(255, 255, 255, 0.8);
        border: none;
        border-radius: 50%;
        width: 40px;
        height: 40px;
        cursor: pointer;
        font-size: 20px;
        color: #0A1F2E;
        transition: background-color 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .slider-nav button:hover {
        background-color: white;
    }
</style>
<?php $__env->startSection('content'); ?>

    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/our-heritage/cover.png')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>OUR HERITAGE</h4>
            <span class="text-primary">Truly Mauritian</span>
        </div>
    </div>

    <div class="container landing-section w-75 mx-auto">
        <div class="row">
            <div class="col-lg-4 col-md-12" data-aos="fade-right" data-aos-duration="700" data-aos-easing="linear">
                <h3>Featuring the Legacy of Phoenix Beverages Group</h3>
            </div>

            <div class="col-lg-8 col-md-12" data-aos="fade-left" data-aos-duration="700" data-aos-easing="linear">
                <P class="text-wrap fs-6" style="text-align: justify">
                    Phoenix Beverages Group's brands have been an integral part of Mauritian heritage and culture for decades.
                    Our locally produced beverages, both alcoholic and non-alcoholic, have each carved out a unique identity as authentically Mauritian.
                    <br></br>
                    Deeply embedded in the local culture, our beverages are a staple at Mauritian festivities, accompanying moments big and small—from beach
                    picnics and family gatherings to nights out and intimate get-togethers.
                    <br></br>
                    With this strong local heritage, we take immense pride in being part of the Mauritian way of life and are honoured to carry this legacy forward.
                    This commitment drives us to continue contributing to the cherished moments, of our Mauritian consumers.
                </P>
            </div>
        </div>
    </div>

    <div class="container w-75 mx-auto my-6" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
        <h2 class="m-0 p-0">Timeline</h2>
        <div class="history-slider mt-4">
            <div class="history-slides-container">
                <?php $__currentLoopData = $historyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="history-slide <?php echo e($index == 0 ? 'active' : ''); ?>">
                        <div class="slide-image">
                            <img src="<?php echo e($history['image']); ?>" alt="History from <?php echo e($history['year_range']); ?>">
                        </div>
                        <div class="slide-content">
                            <div class="year"><?php echo e($history['year_range']); ?></div>
                            <ul>
                                <?php $__currentLoopData = $history['events']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li style="text-align: justify"><?php echo e($event); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="slider-nav">
                <button id="prev-slide">←</button>
                <button id="next-slide">→</button>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const slidesContainer = document.querySelector('.history-slides-container');
    const slides = document.querySelectorAll('.history-slide');
    const nextBtn = document.getElementById('next-slide');
    const prevBtn = document.getElementById('prev-slide');
    let currentSlide = 0;
    let isAnimating = false;

    function goToSlide(newIndex, direction) {
        if (isAnimating) return;
        isAnimating = true;

        const oldIndex = currentSlide;
        const newSlide = slides[newIndex];
        const oldSlide = slides[oldIndex];
        const newImg = newSlide.querySelector('.slide-image img');

        // Prepare the new slide's image to enter from the correct direction
        newImg.style.transition = 'none'; // Move it instantly
        if (direction === 'next') {
            newImg.style.transform = 'translateX(100%)';
        } else {
            newImg.style.transform = 'translateX(-100%)';
        }

        // Force browser to apply the change
        void newImg.offsetWidth;

        // Make the new slide active (it will appear on top due to z-index)
        newSlide.classList.add('active');

        // Re-enable transition and trigger the animation
        newImg.style.transition = 'transform 0.7s cubic-bezier(0.22, 1, 0.36, 1)';
        newImg.style.transform = 'translateX(0)';

        // After the animation finishes, hide the old slide and allow new clicks
        setTimeout(() => {
            oldSlide.classList.remove('active');
            isAnimating = false;
        }, 700); // This duration must match the CSS transition duration

        currentSlide = newIndex;
    }

    nextBtn.addEventListener('click', function() {
        const nextIndex = (currentSlide + 1) % slides.length;
        goToSlide(nextIndex, 'next');
    });

    prevBtn.addEventListener('click', function() {
        const prevIndex = (currentSlide - 1 + slides.length) % slides.length;
        goToSlide(prevIndex, 'prev');
    });

    // Initialize the slider
    slides[0].classList.add('active');
    slides[0].querySelector('.slide-image img').style.transform = 'translateX(0)';
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/our-heritage.blade.php ENDPATH**/ ?>