<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\SeoData;
use App\Services\SeoService;

class MigrateSeoData extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'seo:migrate-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Migrate existing SEO data from controllers to database';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Migrating SEO data to database...');

        // Define the SEO data mapping
        $seoMapping = [
            'home' => [
                'page_name' => 'Homepage',
                'title' => 'Phoenix Beverages Group (PBG) - Leading Beverage Company in Mauritius',
                'description' => 'Phoenix Beverages Group is a leading beverage company in Mauritius and the Indian Ocean region. Discover our diverse portfolio of alcoholic and non-alcoholic beverages.',
                'keywords' => 'Phoenix Beverages, PBG, Mauritius, beverages, beer, soft drinks, spirits, wine, Indian Ocean',
                'image' => 'images/logo.png',
                'url' => '/',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/',
            ],
            'about-us' => [
                'page_name' => 'About Us',
                'title' => 'About Us - Phoenix Beverages Group | Our Story & Heritage',
                'description' => 'Learn about Phoenix Beverages Group\'s journey, heritage, and commitment to excellence in the beverage industry across Mauritius and the Indian Ocean region.',
                'keywords' => 'about Phoenix Beverages, PBG history, beverage company Mauritius, Indian Ocean beverages',
                'image' => 'images/about-banner.png',
                'url' => '/about-us',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/about-us',
            ],
            'contact' => [
                'page_name' => 'Contact Us',
                'title' => 'Contact Us - Phoenix Beverages Group | Get in Touch',
                'description' => 'Contact Phoenix Beverages Group across Mauritius, Rodrigues, Reunion Island, and Seychelles. Find our office locations, phone numbers, and email addresses.',
                'keywords' => 'contact Phoenix Beverages, PBG contact, Mauritius beverage company contact, Seychelles Breweries contact',
                'image' => 'images/contact-banner.png',
                'url' => '/contact',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/contact',
            ],
            'our-brands' => [
                'page_name' => 'Our Brands',
                'title' => 'Our Brands - Phoenix Beverages Group | Premium Beverage Portfolio',
                'description' => 'Discover Phoenix Beverages Group\'s diverse portfolio of premium brands including Phoenix Beer, Coca-Cola, Fanta, Sprite, and our craft beer Manawa. Quality beverages for every occasion.',
                'keywords' => 'Phoenix Beverages brands, PBG products, Phoenix Beer, Coca-Cola Mauritius, Fanta, Sprite, Manawa craft beer, beverage brands',
                'image' => 'images/our-brand-bg.png',
                'url' => '/our-brands',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/our-brands',
            ],
            'news-room' => [
                'page_name' => 'News Room',
                'title' => 'News Room - Phoenix Beverages Group | Latest Updates & Press Releases',
                'description' => 'Stay updated with the latest news, press releases, and announcements from Phoenix Beverages Group. Discover our latest developments, sustainability initiatives, and company updates.',
                'keywords' => 'Phoenix Beverages news, PBG press releases, Mauritius beverage news, company updates, sustainability news',
                'image' => 'images/news-room/news-banner.png',
                'url' => '/news-room',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/news-room',
            ],
            'careers' => [
                'page_name' => 'Careers',
                'title' => 'Careers - Phoenix Beverages Group | Join Our Team',
                'description' => 'Explore career opportunities at Phoenix Beverages Group. Join our dynamic team and be part of Mauritius\' leading beverage company. Discover exciting roles in production, sales, marketing, and more.',
                'keywords' => 'Phoenix Beverages careers, PBG jobs, beverage industry careers, Mauritius jobs, production jobs, sales careers',
                'image' => 'images/careers/careers-banner.png',
                'url' => '/careers',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/careers',
            ],
            'investor-relations' => [
                'page_name' => 'Investor Relations',
                'title' => 'Investor Relations - Phoenix Beverages Group | Financial Reports & Stock Information',
                'description' => 'Access Phoenix Beverages Group\'s investor relations information, financial reports, stock data, and corporate governance documents. Stay informed about our financial performance and growth.',
                'keywords' => 'Phoenix Beverages investor relations, PBG financial reports, stock information, annual reports, quarterly results, Mauritius stock exchange',
                'image' => 'images/investor-relations/investor-banner.png',
                'url' => '/investor-relations',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/investor-relations',
            ],
            'our-leadership' => [
                'page_name' => 'Our Leadership',
                'title' => 'Our Leadership - Phoenix Beverages Group | Board of Directors & Management Team',
                'description' => 'Meet the experienced leadership team at Phoenix Beverages Group. Our board of directors and management team bring decades of expertise in beverage industry, corporate governance, and strategic business development.',
                'keywords' => 'Phoenix Beverages leadership, PBG board of directors, management team, Thierry Lagesse, Jacques D\'Unienville, beverage industry executives',
                'image' => 'images/our-leadership/leadership-banner.png',
                'url' => '/our-leadership',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/our-leadership',
            ],
            'corporate-governance' => [
                'page_name' => 'Corporate Governance',
                'title' => 'Corporate Governance - Phoenix Beverages Group | Board Structure & Policies',
                'description' => 'Learn about Phoenix Beverages Group\'s corporate governance framework, board structure, policies, and commitment to transparency, accountability, and ethical business practices.',
                'keywords' => 'Phoenix Beverages corporate governance, PBG board structure, governance policies, transparency, accountability, ethical business practices',
                'image' => 'images/corporate-governance/governance-cover.png',
                'url' => '/corporate-governance',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/corporate-governance',
            ],
            'esg' => [
                'page_name' => 'ESG & Sustainability',
                'title' => 'ESG & Sustainability - Phoenix Beverages Group | Environmental, Social & Governance',
                'description' => 'Discover Phoenix Beverages Group\'s commitment to Environmental, Social, and Governance (ESG) practices. Learn about our sustainability initiatives, social responsibility, and corporate governance standards.',
                'keywords' => 'Phoenix Beverages ESG, sustainability, environmental responsibility, social impact, corporate governance, green initiatives, Mauritius sustainability',
                'image' => 'images/sustainability/esg-banner.png',
                'url' => '/esg',
                'type' => 'website',
                'author' => 'Phoenix Beverages Group',
                'robots' => 'index, follow',
                'canonical' => '/esg',
            ],
        ];

        $seoService = new SeoService();
        $migrated = 0;

        foreach ($seoMapping as $route => $data) {
            $seoService->saveToDatabase($route, $data);
            $this->line("✓ Migrated SEO data for: {$data['page_name']}");
            $migrated++;
        }

        $this->info("Successfully migrated {$migrated} SEO records to database!");
        $this->info('You can now manage SEO data through the Filament admin panel.');
        
        return 0;
    }
}