@extends('layouts.app')
<style>
    .our-acquisition-container {
        background: url('images/operations-structure/seybrew_island_beer.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        width: 100%;
        height: 100%;
    }

    /* Mobile Responsive Styles */
    @media (max-width: 768px) {
        .about-banner {
            height: 300px !important;
            min-height: 300px;
            background-size: cover !important;
            background-position: center !important;
        }

        .page-title-container {
            position: relative !important;
            margin: 20px auto !important;
            margin-left: auto !important;
            margin-right: auto !important;
            margin-top: 20px !important;
            width: 90% !important;
            max-width: 90% !important;
            min-height: auto !important;
            padding: 30px 20px !important;
            text-align: center;
        }

        .page-title-container h4 {
            font-size: 1.8rem !important;
            margin-bottom: 10px !important;
        }

        .page-title-container .text-primary {
            font-size: 1.2rem !important;
        }

        .landing-section-sus {
            padding-top: 50px !important;
            padding-bottom: 50px !important;
        }

        .landing-section-sus .row {
            margin: 0 !important;
        }

        .landing-section-sus .col-lg-6 {
            padding: 0 15px !important;
            margin-bottom: 30px !important;
        }

        .landing-section-sus h3 {
            font-size: 1.8rem !important;
            margin-bottom: 20px !important;
            text-align: center;
        }

        .landing-section-sus .smaller-text {
            font-size: 0.95rem !important;
            line-height: 1.6 !important;
            text-align: justify;
            margin-bottom: 25px !important;
        }

        .landing-section-sus .learnMore {
            text-align: center !important;
            margin-top: 20px !important;
        }

        .landing-section-sus .learnMore a {
            display: inline-block !important;
            padding: 12px 25px !important;
            font-size: 0.95rem !important;
        }

        .overview-image {
            height: 250px !important;
            margin-top: 20px !important;
            border-radius: 12px !important;
        }

        .our-acquisition-container {
            min-height: 300px !important;
            padding: 20px !important;
        }

        .our-acquisition-container .row {
            margin: 0 !important;
        }

        .our-acquisition-container .col-md-8,
        .our-acquisition-container .col-md-4 {
            margin-top: 0 !important;
            padding: 0 !important;
        }
    }

    @media (max-width: 480px) {
        .about-banner {
            height: 250px !important;
            min-height: 250px;
        }

        .page-title-container {
            width: 95% !important;
            padding: 25px 15px !important;
        }

        .page-title-container h4 {
            font-size: 1.5rem !important;
        }

        .page-title-container .text-primary {
            font-size: 1.1rem !important;
        }

        .landing-section-sus h3 {
            font-size: 1.5rem !important;
        }

        .landing-section-sus .smaller-text {
            font-size: 0.9rem !important;
        }

        .overview-image {
            height: 200px !important;
        }

        .landing-section-sus .learnMore a {
            padding: 10px 20px !important;
            font-size: 0.9rem !important;
        }
    }
</style>
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/operations-structure/seybrew_office_cover.png') }});">
        </div>
        <div class="page-title-container">
            <h4>OUR ACQUISITION</h4>
            <span class="text-primary">New Horizons</span>
        </div>
    </div>



    <div class="container my-6 landing-section-sus">
        <div class="row">
            <div class="col-lg-6 col-md-4 px-5 pt-5" data-aos="fade-right" data-aos-duration="500" data-aos-easing="linear">
                <div class="" >
                    <h3>SEYBREW</h3>
                    <p class="smaller-text">
                        Phoenix Beverages Group (PBG) is proud to announce a significant milestone in its regional expansion, with the
                        acquisition of a controlling 54.4% stake in Seybrew, the Seychelles' leading beverage producer.
                        Effective July 1st, 2025, PBG becomes the primary shareholder of Seybrew, marking a new chapter for both companies.
                    </p>
                </div>

                <div class="learnMore">
                    <a href="{{ route('seybrew') }}" class="smaller-text">Explore</a>
                </div>

            </div>
            <div class="col-lg-6 col-md-4 px-5" data-aos="fade-left" data-aos-duration="500" data-aos-easing="linear">
                
                <div class="overview-image bg-image pbg-shadow"
                style="background-image: url({{ asset('images/operations-structure/seyBrew_Obrien_House_office.png') }})"  class="rounded" >
                </div>
            </div>
        </div>


    </div>

    <div class="landing-section">
        <div class="px-6 our-acquisition-container">
            <div class="row">
                <div class="col-md-8"></div>
                <div class="col-md-4" style="margin-top:120px;">
                </div>
            </div>
        </div>
    </div>


@stop
