<!-- Vertical Side Menu Drawbar Component -->
<!-- Debug: Component loaded -->
<div id="vertical-side-menu" class="vertical-side-menu">
    <!-- Hamburger Menu with Dots -->
    <div class="hamburger-menu" id="hamburger-menu">
        <div class="hamburger-dots">
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
            <span class="dot"></span>
        </div>
    </div>
    
    <!-- Sidebar Drawer -->
    <div class="sidebar-drawer" id="sidebar-drawer">
        <div class="drawer-content">
            <!-- Close Button -->
            <div class="drawer-close" id="drawer-close">
                <i class="fas fa-times"></i>
            </div>
            
                   <!-- Menu Items -->
                   <div class="drawer-menu-items">
                       <div class="drawer-menu-item active" data-tooltip="Home">
                           <a href="#home" class="drawer-menu-link">
                               <i class="fas fa-home"></i>
                               <span class="menu-text">Home</span>
                           </a>
                       </div>
                
                @php
                    $currentRoute = request()->route()->getName() ?? '';
                    $isPiclOrCicl = str_contains($currentRoute, 'picl') || str_contains($currentRoute, 'cicl');
                @endphp
                
                @if(!$isPiclOrCicl)
                <div class="drawer-menu-item" data-tooltip="Finance at a glance">
                    <a href="#finance-at-a-glance" class="drawer-menu-link">
                        <i class="fas fa-chart-line"></i>
                        <span class="menu-text">Finance at a glance</span>
                    </a>
                </div>
                @endif
                
                <div class="drawer-menu-item" data-tooltip="Remarks">
                    <a href="#remarks" class="drawer-menu-link">
                        <i class="fas fa-comments"></i>
                        <span class="menu-text">Remarks</span>
                    </a>
                </div>
                
                <div class="drawer-menu-item" data-tooltip="Welcome - Main website">
                    <a href="{{ route('home') }}" class="drawer-menu-link">
                        <i class="fas fa-globe"></i>
                        <span class="menu-text">Welcome</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Include CSS and JS for vertical menu -->
@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
@endpush

@push('scripts')
<script src="{{ asset('js/vertical-menu.js') }}"></script>
@endpush

<!-- Inline styles as fallback -->
<style>
.vertical-side-menu {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 9999;
}

.hamburger-menu {
    width: 50px;
    height: 50px;
    background: transparent;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    /* Ensure it's always visible in top right */
    top: 0;
    right: 0;
}

.hamburger-menu:hover {
    transform: scale(1.05);
}

.hamburger-dots {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 6px;
    width: 30px;
    height: 30px;
}

.dot {
    width: 5px;
    height: 5px;
    background: #08BABB;
    transition: all 0.2s ease;
}

.hamburger-menu:hover .dot {
    background: #065f61;
    transform: scale(1.1);
}

.sidebar-drawer {
    position: fixed;
    top: 0;
    right: -400px;
    width: 350px;
    height: 100vh;
    background: #0A1F2E;
    box-shadow: -15px 0 40px rgba(0, 0, 0, 0.25), -5px 0 20px rgba(8, 186, 187, 0.1);
    border-left: 3px solid #08BABB;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 10001;
    overflow-y: auto;
    /* Ensure crisp rendering and clickable elements */
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    text-rendering: optimizeLegibility;
    /* Ensure all elements are clickable */
    pointer-events: auto;
}

.sidebar-drawer.open {
    right: 0;
}

.drawer-content {
    padding: 20px;
    height: 100%;
    display: flex;
    flex-direction: column;
}

.drawer-close {
    width: 45px;
    height: 45px;
    background: #08BABB;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    margin-bottom: 30px;
    transition: all 0.3s ease;
    align-self: flex-end;
    box-shadow: 0 4px 15px rgba(8, 186, 187, 0.3);
}

.drawer-close:hover {
    background: #065f61;
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(8, 186, 187, 0.4);
}

.drawer-close i {
    color: white;
    font-size: 18px;
    font-weight: bold;
}

.drawer-menu-items {
    display: flex;
    flex-direction: column;
    gap: 15px;
}

.drawer-menu-item {
    background: rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 0;
    transition: all 0.3s ease;
    border: 1px solid rgba(8, 186, 187, 0.2);
    cursor: pointer;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.drawer-menu-item:hover {
    background: #08BABB;
    border-color: #08BABB;
    transform: translateX(-5px);
    box-shadow: 0 4px 15px rgba(8, 186, 187, 0.3);
}

.drawer-menu-item.active {
    background: #08BABB;
    border-color: #08BABB;
    box-shadow: 0 4px 15px rgba(8, 186, 187, 0.3);
}

.drawer-menu-item.active .drawer-menu-link {
    color: white;
}

.drawer-menu-link {
    display: flex;
    align-items: center;
    padding: 18px 20px;
    text-decoration: none;
    color: #ffffff;
    transition: all 0.3s ease;
    border-radius: 8px;
    font-weight: 500;
}

.drawer-menu-item:hover .drawer-menu-link {
    color: white;
}

.drawer-menu-link i {
    font-size: 18px;
    margin-right: 15px;
    width: 20px;
    text-align: center;
    transition: all 0.3s ease;
}

.drawer-menu-item:hover .drawer-menu-link i {
    transform: scale(1.1);
}

.menu-text {
    font-weight: 500;
    font-size: 15px;
}

.drawer-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
    pointer-events: none;
    clip-path: polygon(0 0, calc(100% - 350px) 0, calc(100% - 350px) 100%, 0 100%);
}

.drawer-overlay.active {
    opacity: 1;
    visibility: visible;
}
</style>
