@extends('layouts.app')
<style>
    button.accordion-button.collapsed::after {
        color: #ffffff !important;
        background-color: #08BABB !important;
    }


    .accordion-button:not(.collapsed)::after {
        color: #ffffff !important;
        background-color: #08BABB !important;
    }
</style>
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/sustainability/sustainability-footprint_cover.png') }});">
        </div>
        <div class="page-title-container">
            <h4>OUR FOOTPRINTS</h4>
            <span class="text-primary">Our Engagements are our Footprints. It is the best way to narrate our Story</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2">
                <div class="center">
                    <h3 data-aos="fade-down" data-aos-delay="500">Leaving Sustainable Footprints for Future Generations</h3>
                    <p style="text-align: justify" data-aos="fade-up" data-aos-delay="500">As an industry leader, creating a sustainable ecosystem around Phoenix Beverages Group is our top priority.
                        Sustainability is deeply ingrained in our brand DNA, driving us to operate responsibly across all our activities. Phoenix Beverages Group has outlined
                        a dedicated sustainability strategy, focusing on a clear set of priority actions.
                    </p>
                    <p style="text-align: justify" data-aos="fade-up" data-aos-delay="500">Our strategy is centered on building a sustainable and profitable business by taking a balanced approach to social,
                        environmental, and financial performance. To guide this, we have selected five United Nations Sustainable Development Goals (SDGs) most relevant
                        to our operations. These SDGs serve as our guiding principles, helping ensure our activities contribute meaningfully to global social and
                        environmental progress. By aligning them with the structure of Environmental, Social, and Governance (ESG) principles, we ensure our efforts
                        remain measurable, impactful, and transparent across the organisation.
                    </p>
                </div>
            </div>
        </div>

        <div class="row mt-100">
            <div class="col-lg-3 col-md-6 col-12 mb-4" data-aos="fade-up" data-aos-delay="100">
                <a href="https://phoenixearth.mu/" target="_blank">
                    <div class="overview-image bg-image"
                         style="background-image: url({{ asset('images/foot-prints/esg_embedding_project.png') }});height: 460px !important;"  class="" >
                    </div>
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-12 mb-4" data-aos="fade-up" data-aos-delay="200">
                <a href="https://phoenixearth.mu/" target="_blank">
                    <div class="overview-image bg-image"
                         style="background-image: url({{ asset('images/foot-prints/environment_esg.png') }});height: 460px !important;"  class="" >
                    </div>
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-12 mb-4" data-aos="fade-up" data-aos-delay="300">
                <a href="https://phoenixearth.mu/" target="_blank">
                    <div class="overview-image bg-image"
                         style="background-image: url({{ asset('images/foot-prints/social_esg.png') }});height: 460px !important;"  class="" >
                    </div>
                </a>
            </div>
            <div class="col-lg-3 col-md-6 col-12 mb-4" data-aos="fade-up" data-aos-delay="400">
                <a href="https://phoenixearth.mu/" target="_blank">
                    <div class="overview-image bg-image"
                         style="background-image: url({{ asset('images/foot-prints/governance_esg.png') }});height: 460px !important;"  class="" >
                    </div>
                </a>
            </div>
            {{-- <div class="col">
                <img class="" src="{{ asset('images/foot-image-5.png') }}">
            </div> --}}
        </div>

        <div class="row mt-100">
            <div class="col-12 col-lg-5 mb-4" data-aos="fade-right" data-aos-delay="1000">
                <div class="bg-dark foot-print-container pbg-shadow radius-8">
                    <h5 class="text-primary" style="text-align: justify">Phoenix Beverages Group has established a comprehensive sustainability
                        strategy, prioritizing a specific set of actions.
                        This strategic framework serves as a roadmap to guide investments, improve performance, and foster
                        engagement with both internal
                        and external stakeholders.
                    </h5>
                </div>
            </div>
            <div class="col-12 col-lg-6 offset-lg-1" data-aos="fade-left" data-aos-delay="1000">
                <div>
                    <strong class="text-primary">Our Strategy</strong>
                    <p style="text-align: justify">By evaluating internal and external sustainability improvements and expectations, we gather valuable
                        insights to inform our strategic decision-making.
                        Our strategy not only prioritizes sustainability goals but also involves concrete actions to address
                        specific issues and drive meaningful change.</p>
                </div>
                <div>
                    <strong class="text-primary">Entrepreneur Approach </strong>
                    <p style="text-align: justify">Through clear and decisive action, Phoenix Beverages Group intends to showcase its entrepreneurial
                        approach, prioritizing the future.
                        This sustainability strategy is fully aligned with the Group's global mission and vision,
                        emphasizing a long-term perspective.</p>
                </div>
                <div>
                    <strong class="text-primary">Support</strong>
                    <p style="text-align: justify">Phoenix Beverages Group, through its PhoenixEarth Initiative, actively supports a range of NGOs and
                        initiatives. These include the Mauritius Glass Gallery (MGG),
                        YesNo Solutions, Mission Verte, We-Recycle, The Coca-Cola Foundation, Zee Arts, and others.</p>
                </div>
            </div>
        </div>

    </div>

    <div class="bg-dark mt-100">
        <div class="container pt-100 pb-100">
            <h3 class="center" data-aos="fade-up" data-aos-delay="500">Sustainable Development Goals </h3>
            <div class="accordion pbg-accordion" id="accordionPanelsStayOpenFootPrint" >
                <div class="accordion-item" data-aos="fade-up" data-aos-delay="500">
                    <h2 class="accordion-header" id="panelsStayOpen-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                            aria-controls="panelsStayOpen-collapseOne">
                            Sustainability Reporting
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="panelsStayOpen-headingOne" data-bs-parent="#accordionPanelsStayOpenFootPrint">
                        <div class="accordion-body">
                            <p style="text-align: justify">Sustainability is embedded in our strategy and guided by the Triple Bottom Line: People, Planet, and Prosperity.
                                We take a balanced approach to social, environmental, and financial performance, and have aligned our operations with five United Nations
                                Sustainable Development Goals (SDGs) most relevant to our business. Our approach connects the global vision of the SDGs with the structure
                                of Environmental, Social, and Governance (ESG) principles, ensuring our efforts are measurable, impactful, and transparent across
                                the organisation.
                            </p>
                            <p style="text-align: justify">To strengthen our ESG integration, we conducted a double materiality assessment in collaboration with the embedding Project,
                                embedding ESG principles into eight key business areas. This comprehensive approach, combining the UN SDGs and materiality, guides our clear ESG strategy
                                and governance structure. For each material issue, measurable KPIs are established, supported by cross-functional collaboration and employee training.
                                These KPIs are embedded into our culture and operations, enabling us to monitor progress and adapt our strategy in response to evolving ESG trends,
                                stakeholder expectations, and market dynamics.
                            </p>
                        </div>
                    </div>
                </div>
                {{-- <div class="accordion-item" data-aos="fade-up" data-aos-delay="500">
                    <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseTwo">
                            Sustainable Village
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingTwo" data-bs-parent="#accordionPanelsStayOpenFootPrint">
                        <div class="accordion-body">
                            <p style="text-align: justify">The PhoenixEarth Initiative’s sustainability reporting is essential for tracking Phoenix
                                Beverages Group’s sustainable actions
                                and improving KPIs aligned with our set targets.
                            </p>
                            <p style="text-align: justify">This reporting monitors progress internally across our factories and branches and externally
                                in our contributions to Mauritian society and the broader island community. It also helps us identify risks,
                                opportunities, and areas for improvement.
                            </p>
                        </div>
                    </div>
                </div> --}}
                <div class="accordion-item" data-aos="fade-up" data-aos-delay="500">
                    <h2 class="accordion-header" id="panelsStayOpen-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseThree" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseThree">
                            Responsible Sourcing
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingThree" data-bs-parent="#accordionPanelsStayOpenFootPrint">
                        <div class="accordion-body">
                            <p style="text-align: justify">At Phoenix Beverages Group, responsible sourcing is not just a business necessity; it is a commitment to ensuring
                                a sustainable future for our planet, people, and the communities we serve. By continuously innovating and collaborating with our partners,
                                we aim to lead the way in sustainable procurement in Mauritius and beyond.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="accordion-item" data-aos="fade-up" data-aos-delay="500">
                    <h2 class="accordion-header" id="panelsStayOpen-headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-CollapseFour" aria-expanded="false"
                            aria-controls="panelsStayOpen-CollapseFour">
                            Responsible Consumption
                        </button>
                    </h2>
                    <div id="panelsStayOpen-CollapseFour" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingFour" data-bs-parent="#accordionPanelsStayOpenFootPrint">
                        <div class="accordion-body">
                            <p style="text-align: justify">Phoenix Beverages Group is committed to shaping a sustainable future through responsible
                                consumption.
                                By empowering consumers with knowledge and tools to make environmentally and socially
                                conscious choices,
                                we aim to inspire change and make a lasting positive impact on Mauritius and beyond.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="landing-section">

    </div>


@stop
