<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta http-equiv="x-ua-compatible" content="IE=edge">
    <meta name="author" content="SemiColonWeb">
    <meta name="description" content="Phoenix Beverages Group Integrated Report">

    <!-- Font Imports -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:ital@0;1&display=swap"
        rel="stylesheet">

    <!-- Core Style -->
    <link rel="stylesheet" href="{{ URL::asset('layout/style.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('layout/custom.css') }}">

    <!-- Font Icons -->
    <link rel="stylesheet" href="{{ URL::asset('layout/css/font-icons.css') }}">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ URL::asset('layout/css/custom.css') }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- SLIDER REVOLUTION 5.x CSS SETTINGS -->
    <link rel="stylesheet" href="{{ URL::asset('layout/include/rs-plugin/css/settings.css') }}" media="screen">
    <link rel="stylesheet" href="{{ URL::asset('layout/include/rs-plugin/css/layers.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('layout/include/rs-plugin/css/navigation.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('layout/include/slick/slick/slick.css') }}">
    <link rel="stylesheet" href="https://cdn.knightlab.com/libs/timeline3/latest/css/timeline.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <style>
        .overview-image {
            /* height: 392px; */
            height: 420px;
            max-width: 600px;
            border-radius: 8px;
            position: relative;
            transition: transform 0.4s ease, opacity 0.4s ease, box-shadow 0.4s ease;
            overflow: hidden;
        }
    </style>

    <!-- Vertical Menu Styles -->
    @stack('styles')

    <!-- Document Title -->
    <title>@yield('title', 'Phoenix Beverages Group (PBG)')</title>
</head>

<body class="stretched">
    <div id="wrapper">
        <header id="header">
            <div id="header-wrap">
                <div class="container py-3">
                    <div class="header-row">
                        <div id="logo">
                            <a href="{{ route('home') }}">
                                <img class="logo-default" srcset="{{ URL::asset('images/pbg-logo.png') }}"
                                    src="{{ URL::asset('images/pbg-logo.png') }}" alt="PBG Logo">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Include Vertical Side Menu Component -->
        <x-vertical-menu />

        @yield('content')
    </div>

    <footer id="footer" class="dark">
        <div class="container">
            <div id="pbv-copyrights">
                <div class="container">
                    <div class="row col-mb-30">
                        <div class="col-md-5 text-center text-md-start">
                            Copyright &copy; {{ date('Y') }} Phoenix Beverages Group. All Rights Reserved.<br>
                        </div>
                        <div class="col-md-5 text-center text-md-start">
                            <div class="copyright-links">
                                <a href="#">Terms & Conditions</a> |
                                <a href="#">Cookies Policy</a> |
                                <a href="#">Privacy Policy</a>
                            </div>
                        </div>
                        <div class="col-md-2 text-center text-md-end">
                            Developed by Zethical
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/countup@1.8.2/countUp.js"></script>

    <!-- Initialize AOS -->
    <script>
        AOS.init({
            duration: 500,
            easing: 'linear',
            once: true
        });
    </script>

    <!-- Vertical Menu Scripts -->
    @stack('scripts')

    @yield('scripts')
</body>

</html>
