@extends('layouts.app')
<style>
    .pagination-container {
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .arrow-text {
        display: block;
        vertical-align: middle;
        font-size: 13px;
    }

    .pagination-number {
        --size: 32px;
        --margin: 6px;
        margin: 0 var(--margin);
        border-radius: 6px;
        background: #071621;
        max-width: auto;
        min-width: var(--size);
        height: var(--size);
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        padding: 0 6px;
    }

    .pagination-number a {
        color: #fff !important;
    }

    .pagination-active {
        background-color: #08BABB;
    }

    .pagination-number.arrow {
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
    }

    .pagination-number.arrow.disabled {
        pointer-events: none;
        opacity: 0.5;
    }

    input[type="radio"]:checked {
        background-color: #08BABB;
        border-color: #08BABB;
        color: #08BABB;
    }


    input[type="radio"]:checked+label {
        color: #08BABB;
    }

    input[type="radio"] {
        accent-color: #08BABB;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 2px solid #ccc;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    input[type="radio"]:hover {
        border-color: #08BABB;
    }

    .filter-group label {
        font-size: 18px;
        cursor: pointer;
    }

    .filter-group label:hover {
        color: #08BABB;
    }


    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }


    .loader-container {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }

    .loader {
        border: 4px solid #f3f3f3;
        border-top: 4px solid #3498db;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 2s linear infinite;
    }


    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    .search-container {
        position: relative;
    }

    .search-container .clear-search {
        position: absolute;
        right: 10px;
        top: 50%;
        transform: translateY(-50%);
        background: none;
        border: none;
        color: #08BABB;
        font-size: 18px;
        cursor: pointer;
        padding: 5px;
        display: none;
        transition: all 0.3s ease;
    }

    .search-container .clear-search:hover {
        color: #071621;
    }

    .search-container .clear-search.visible {
        display: block;
    }

    .search-container .fa-search {
        position: absolute;
        left: 10px;
        top: 50%;
        transform: translateY(-50%);
        color: #08BABB;
    }

    .search-container input {
        padding-left: 35px;
        padding-right: 35px;
    }
</style>
@section('content')
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url({{ asset('images/news-room/news-cover.png') }});">
        </div>
        <div class="page-title-container">
            <h4>NEWSROOM</h4>
            <span class="text-primary">Latest Update</span>
        </div>
    </div>

    <div class="container landing-section news-category">
        <div class="row">
            <div class="col-md-6 col-lg-7">
                <h5>Categories</h5>
                <form id="category-filter-form">
                    <div class="ul-container">
                        <div class="filter-group">
                            <label>
                                <input type="radio"
                                    {{ request('category') == 'all' || request('category') != '' ? 'checked' : '' }}
                                    name="category" value="all" checked> All
                            </label>
                            {{-- <label>
                                <input type="radio" {{ request('category') == 'sdg' ? 'checked' : '' }} name="category"
                                    value="sdg"> SDG's
                            </label> --}}
                            <label>
                                <input type="radio" {{ request('category') == 'sustainability' ? 'checked' : '' }}
                                    name="category" value="sustainability"> ESG
                            </label>
                            <label>
                                <input type="radio" {{ request('category') == 'technology' ? 'checked' : '' }}
                                    name="category" value="technology"> Technology
                            </label>
                        </div>
                        <div class="filter-group">
                            <label>
                                <input type="radio" {{ request('category') == 'press release' ? 'checked' : '' }}
                                    name="category" value="press release"> Press Release
                            </label>
                            <label>
                                <input type="radio" {{ request('category') == 'press articles' ? 'checked' : '' }}
                                    name="category" value="press articles"> Press Articles
                            </label>
                            <label>
                                <input type="radio" {{ request('category') == 'news' ? 'checked' : '' }} name="category"
                                    value="news"> News
                            </label>
                            <label>
                                <input type="radio" {{ request('category') == 'events' ? 'checked' : '' }} name="category"
                                    value="events"> Events
                            </label>
                        </div>

                    </div>
                </form>
            </div>

            <div class="col-md-6 col-lg-5">
                <div class="search-container">
                    <span class="fa fa-search"></span>
                    <input type="text" id="searchInput" class="form-control" placeholder="Search here"
                        value="{{ old('search', $searchQuery) }}">
                    <button type="button" class="clear-search" id="clearSearch" title="Clear search">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            </div>

        </div>

    </div>


    <div class="container mt-5 mb-6">
        <hr style="border-top: 2px solid #08BABB;">
    </div>


    <div id="loader" class="loader-container">
        <div class="loader"></div>
    </div>

    <div class="container my-6">
        {{-- <h3 class="mb-6">latest news</h3> --}}
        <div class="row newsroom-biobin mx-auto">
            <div class="col-lg-6 col-md-12">
                <img src="{{ $displayNews[0]->image_url }}"
                    alt="{{ $displayNews[0]->title }}" />
                <span class="overlay-button">{{ $displayNews[0]->category }}</span>
            </div>
            <div class="col-lg-6 col-md-12 newsroom-text">
                <h2><a href="{{ route('news.details', $displayNews[0]->id) }}">{{ $displayNews[0]->title }}</a></h2>
                <p>{!! $displayNews[0]->body !!}</p>
                <span class="date">{{ $displayNews[0]->date }}</span>
            </div>
        </div>
    </div>


    <br>
    <div class="container my-6">
        <div class="row newsroom-crop mx-auto ">
            <div class="col-lg-5 col-md-12">
                <img src="{{ $displayNews[1]->image_url }}"
                    alt="{{ $displayNews[1]->title }}" />
                <div class="newsroom-plant">
                    <h4><a href="{{ route('news.details', $displayNews[1]->id) }}">{{ $displayNews[1]->title }}</a>
                    </h4>
                    <p>{!! \Str::limit($displayNews[1]->body, 400, '[...]') !!}</p>
                    <span class="date smaller-text">{{ $displayNews[1]->date }}</span>

                </div>
            </div>
            <div class="col-lg-6 col-md-12 newsroom-div">
                <h4>Most Read Articles</h4>
                <div class="row ">
                    <div class="col-lg-6 col-md-6  news-room-content">
                        <img src="{{ $displayNews[2]->image_url }}"
                            alt="{{ $displayNews[2]->title }}" />
                    </div>
                    <div class="col-lg-6 col-md-6 detail-news">
                        <p><a href="{{ route('news.details', $displayNews[2]->id) }}">{!! $displayNews[2]->title !!}</a></p>
                        <p class="date smaller-text">{{ $displayNews[2]->date }}</p>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-lg-6 col-md-6  news-room-content">
                        <img src="{{ $displayNews[3]->image_url }}"
                            alt="{{ $displayNews[3]->title }}" />
                    </div>
                    <div class="col-lg-6 col-md-6 detail-news">
                        <p><a href="{{ route('news.details', $displayNews[3]->id) }}">{!! $displayNews[3]->title !!}</a></p>
                        <p class="date smaller-text">{{ $displayNews[3]->date }}</p>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-lg-6 col-md-6  news-room-content">
                        <img src="{{ $displayNews[4]->image_url }}"
                            alt="{{ $displayNews[4]->title }}" />
                    </div>
                    <div class="col-lg-6 col-md-6 detail-news">
                        <p><a href="{{ route('news.details', $displayNews[4]->id) }}">{!! $displayNews[4]->title !!}</a></p>
                        <p class="date smaller-text">{{ $displayNews[4]->date }}</p>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <br>
    <div class="container my-6">

        <div class="row all-news-class" id="all-news-id">
            @unless (empty($news))
                @foreach ($news as $newsDetail)
                    <div class="col-md-12 col-lg-4  mb-4">
                        <div class="news-room-container">
                            <div class="news-box">
                                <img src="{{ $newsDetail->image_url }}" alt="News Image">
                                <div class="overlay">
                                    <span>{{ $newsDetail->category }}</span>
                                </div>
                            </div>
                            <div class="news-room-text">
                                <p class="news-room-title">
                                    <a href="{{ route('news.details', $newsDetail->id) }}">
                                        {{ \Str::limit($newsDetail->title, 200, '[...]') }}
                                    </a>
                                </p>
                                <div class="news-meta">
                                    <p class="news-room-date">{{ $newsDetail->date }}</p>
                                    {{-- <div class="read-more">Read more</div> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            @else
                <i class="text-center smallest-text">No News to display under the selected category</i>

            @endunless

        </div>

        @unless (empty($news))
            <div class="pagination-container mt-5" id="pagination-container">
                @if ($news->onFirstPage())
                    <div class="pagination-number arrow left disabled">
                        <span class="arrow-text">Previous</span>
                    </div>
                @else
                    <div class="pagination-number arrow left">
                        <a href="{{ $news->previousPageUrl() }}" class="pagination-link">
                            <span class="arrow-text">Previous</span>
                        </a>
                    </div>
                @endif

                <!-- Page Numbers -->
                @for ($i = 1; $i <= $news->lastPage(); $i++)
                    <div class="pagination-number {{ $news->currentPage() == $i ? 'pagination-active' : '' }}">
                        <a href="{{ $news->url($i) }}" class="pagination-link">
                            {{ $i }}
                        </a>
                    </div>
                @endfor

                <!-- Next Button -->
                @if ($news->hasMorePages())
                    <div class="pagination-number arrow right">
                        <a href="{{ $news->nextPageUrl() }}" class="pagination-link">
                            <span class="arrow-text">Next</span>
                        </a>
                    </div>
                @else
                    <div class="pagination-number arrow right disabled">
                        <span class="arrow-text">Next</span>
                    </div>
                @endif
            </div>
        @endunless

    </div>



    <script>
        var current_page = 1;
        var image_base_path = "{{ asset('images') }}";
        console.log(image_base_path)

        // Add search functionality
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('searchInput');
            const clearSearchBtn = document.getElementById('clearSearch');
            const categoryForm = document.getElementById('category-filter-form');
            const loader = document.getElementById('loader');
            const newsContainer = document.getElementById('all-news-id');
            const paginationContainer = document.getElementById('pagination-container');
            let searchTimeout;

            // Function to update clear button visibility
            function updateClearButton() {
                if (searchInput.value.trim()) {
                    clearSearchBtn.classList.add('visible');
                } else {
                    clearSearchBtn.classList.remove('visible');
                }
            }

            // Function to reset search
            function resetSearch() {
                searchInput.value = '';
                clearSearchBtn.classList.remove('visible');
                const selectedCategory = document.querySelector('input[name="category"]:checked')?.value || 'all';
                updateResults('', selectedCategory);
            }

            // Function to scroll to results
            function scrollToResults() {
                const resultsSection = document.querySelector('.all-news-class');
                if (resultsSection) {
                    resultsSection.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }

            // Function to update results via AJAX
            function updateResults(search = '', category = '', fullUrl = null) {
                const loader = document.getElementById('loader');
                const newsContainer = document.getElementById('all-news-id');
                const paginationContainer = document.getElementById('pagination-container');

                const requestUrl = fullUrl || `${window.location.pathname}?search=${search}&category=${category}`;

                loader.style.display = 'flex';

                fetch(requestUrl)
                    .then(response => response.text())
                    .then(html => {
                        const parser = new DOMParser();
                        const doc = parser.parseFromString(html, 'text/html');

                        const newNewsContainer = doc.getElementById('all-news-id');
                        if (newNewsContainer) {
                            newsContainer.innerHTML = newNewsContainer.innerHTML;
                        }

                        const newPagination = doc.getElementById('pagination-container');
                        if (newPagination) {
                            paginationContainer.innerHTML = newPagination.innerHTML;
                        } else {
                            paginationContainer.innerHTML = '';
                        }

                        window.history.pushState({}, '', requestUrl);
                        scrollToResults(); // Optional scroll
                    })
                    .catch(err => console.error('Pagination AJAX error:', err))
                    .finally(() => {
                        loader.style.display = 'none';
                    });
            }


            // Function to trigger search
            function triggerSearch() {
                const searchValue = searchInput.value.trim();
                // Only proceed if there's actual search text
                if (searchValue) {
                    const selectedCategory = document.querySelector('input[name="category"]:checked')?.value ||
                        'all';
                    updateResults(searchValue, selectedCategory);
                }
            }

            // Handle search input
            searchInput.addEventListener('input', function() {
                clearTimeout(searchTimeout);
                updateClearButton();
                const searchValue = this.value.trim();
                // Only set timeout if there's actual search text
                if (searchValue) {
                    searchTimeout = setTimeout(triggerSearch, 5000); // 5 seconds delay
                }
            });

            // Handle clear button click
            clearSearchBtn.addEventListener('click', function() {
                searchInput.value = '';
                clearSearchBtn.classList.remove('visible');
                const selectedCategory = document.querySelector('input[name="category"]:checked')?.value ||
                    'all';
                updateResults('', selectedCategory);
            });

            // Handle Enter key
            searchInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    clearTimeout(searchTimeout); // Clear the 5-second timeout
                    const searchValue = this.value.trim();
                    // Only trigger search if there's actual search text
                    if (searchValue) {
                        triggerSearch();
                    }
                }
            });

            // Handle category changes
            categoryForm.addEventListener('change', function(e) {
                if (e.target.name === 'category') {
                    const searchValue = searchInput.value.trim();
                    // Only include search if there's actual search text
                    updateResults(searchValue || '', e.target.value);
                }
            });

            // Handle pagination clicks
            document.addEventListener('click', function(e) {
                const link = e.target.closest('.pagination-link');
                if (link) {
                    e.preventDefault();
                    const href = link.getAttribute('href');
                    if (!href) return;

                    const url = new URL(href, window.location.origin);
                    const searchValue = document.getElementById('searchInput')?.value.trim();
                    const selectedCategory = document.querySelector('input[name="category"]:checked')
                        ?.value || 'all';

                    if (searchValue) url.searchParams.set('search', searchValue);
                    if (selectedCategory) url.searchParams.set('category', selectedCategory);

                    updateResults(searchValue, selectedCategory, url.toString());
                }
            });

            // Initialize clear button state
            updateClearButton();
        });
    </script>

@stop
