<style>
    .pbg-accordion .white-accordion .accordion-button {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
        padding: 0px !important;
    }

    .pbg-accordion .white-accordion .accordion-body p {
        color: black !important;
        font-weight: 400;
        font-size: 12px;
    }

    .pbg-accordion .white-accordion .accordion-body {
        border: none !important;
        margin: auto;
        width: 90%;
    }

    .white-accordion {
        background-color: white !important;
        font-size: 16px !important;
        color: black !important;
        font-weight: bold;
        box-shadow: none;
    }

    .operation-parent-container {
        position: relative;
        width: 100%;
        height: 100vh;
        padding-top: 60px;
    }

    .seybrew-beer-container {
        background: url('../images/operations-structure/seybre_imgs/seybre_factory.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        width: 100%;
        height: 100%;
        transition: background-image 0.3s ease;
        min-height: 100vh;
    }

    /* Background classes for different accordion states */
    .bg-beer-portfolio {
        background-image: url('../images/operations-structure/seybrew_island_beer.png') !important;
    }

    .bg-cider-portfolio {
        background-image: url('../images/operations-structure/seybrew_office_cover.png') !important;
    }

    .bg-soft-portfolio {
        background-image: url('../images/operations-structure/seyBrew_Obrien_House_office.png') !important;
    }

    .bg-brands-license {
        background-image: url('../images/operations-structure/seybre_imgs/seybre_factory.png') !important;
    }

    /* Accordion container height fix - no overflow */
    .accordion.pbg-accordion {
        height: auto;
        max-height: 65vh;
        overflow: hidden;
    }

    .accordion-item.white-accordion {
        margin-bottom: 10px;
    }

    .accordion-body {
        max-height: 200px;
        overflow-y: auto;
        scrollbar-width: thin;
        scrollbar-color: #08BABB #f0f0f0;
    }

    .accordion-body::-webkit-scrollbar {
        width: 4px;
    }

    .accordion-body::-webkit-scrollbar-track {
        background: #f0f0f0;
        border-radius: 2px;
    }

    .accordion-body::-webkit-scrollbar-thumb {
        background: #08BABB;
        border-radius: 2px;
    }

    .accordion-body::-webkit-scrollbar-thumb:hover {
        background: #069a9c;
    }

    /* Mobile responsive adjustments */
    @media (max-width: 768px) {
        .accordion.pbg-accordion {
            max-height: 55vh;
        }
        
        .accordion-body {
            max-height: 150px;
        }
        
        .seybrew-beer-container {
            min-height: 80vh;
        }
    }

    @media (max-width: 480px) {
        .accordion.pbg-accordion {
            max-height: 50vh;
        }
        
        .accordion-body {
            max-height: 120px;
        }
        
        .seybrew-beer-container {
            min-height: 75vh;
        }
    }
</style>
<?php $__env->startSection('content'); ?>

    <div class="container landing-section">
        <div class="row">
            <div class="col-12 col-lg-8 offset-lg-2 text-center">
                <div class="header mb-4" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                        <div class="back-button">
                            <a href="<?php echo e(route('operations-structure')); ?>">
                                <span class="fas fa-arrow-left"></span> Back
                            </a>
                        </div>
                        <h2 class="mb-6">SEYBREW</h2>
                </div>

                <p style="text-align: justify" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear"><b>Phoenix Beverages Group (PBG) is proud to announce a significant milestone in its regional expansion,
                    with the acquisition of a controlling 54.4% stake in Seybrew, the Seychelles' leading beverage producer. Effective July 1st, 2025,
                    PBG becomes the primary shareholder of Seybrew, marking a new chapter for both companies.</b>

                </p>
                <p style="text-align: justify" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear"> Established in 1972, Seybrew has long been an iconic name in the Seychelles, deeply rooted in the local culture and economy.
                    Operating previously as a subsidiary of Diageo, Seybrew has built a formidable reputation for quality and market leadership.
                    It is a public limited company, with its shares actively traded on the Seychelles Securities Exchange (MERJ).
                </p>


                <p class="phoenix-bev-text" style="text-align: justify" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                    Seybrew is synonymous with its flagship product, the much-loved <b>Seybrew Lager</b>, which dominates the local beer market. Beyond its popular beer,
                    the company boasts a comprehensive portfolio that includes a diverse range of soft drinks, refreshing mineral waters, and a selection of spirits
                    produced under Diageo’s license. Over the years, Seybrew has continually innovated, expanding its offerings with successful local brands such
                    as <b>SeyPearl soft drinks</b> and the unique <b>Vann Swet beer</b>.
                </p>

                <p class="phoenix-bev-text" style="text-align: justify" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                    Furthermore, Seybrew plays a crucial role in supplying the local market with an impressive array of imported Diageo spirits brands,
                    reinforcing its position as a key player in the Seychelles beverage industry.
                </p>

                <p class="phoenix-bev-text" style="text-align: justify" data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
                    This strategic acquisition by Phoenix Beverages Group underscores our commitment to growth and strengthening our presence across the Indian Ocean region.
                    We look forward to leveraging our expertise and resources to further enhance Seybrew's success, while continuing to serve the Seychellois community
                    with the high-quality beverages they have come to know and love.
                </p>

                
            </div>

        </div>

    </div>

    <div class="operation-parent-container">
        <div class="p-6 seybrew-beer-container " data-aos="fade-up" data-aos-duration="500" data-aos-easing="linear">
            <div class="row">
                <div class="col-md-8"></div>
                <div class="col-md-4">
                    <div class="accordion pbg-accordion" id="accordionPanelsStayOpenExample">
                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingTwenty">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseTwenty" aria-expanded="true"
                                    aria-controls="panelsStayOpen-collapseTwenty">
                                    Beers Portfolio (SeyBrew Owned Product)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseTwenty" class="accordion-collapse collapse show"
                                aria-labelledby="panelsStayOpen-headingTwenty"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify"><b>Seybrew Beer:</b><br>
                                        Seybrew Lager is the flagship product of Seybrew, the leading beverage producer in Seychelles. It is a highly popular
                                        and well-established beer that significantly dominates the local beer market.
                                    </p>
                                    <p><img src="<?php echo e(asset('images/operations-structure/seybre_imgs/seybrew_beer_logo.png')); ?>" alt="seybrew_beer_logo" />
                                    </p>
                                    <p style="text-align: justify"><b>Vann Swet Beer:</b><br>
                                        Vann Swet is a unique beer product from Seybrew, representing an expansion in their beverage offerings alongside their core Seybrew Lager.
                                    </p>
                                    <p><img src="<?php echo e(asset('images/operations-structure/seybre_imgs/vann_swet_logo.png')); ?>" alt="seybrew_beer_logo" />
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingEleven">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseEleven" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseEleven">
                                    Cider Portfolio (SeyBrew Owned Product)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseEleven" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingEleven"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify"><b>Slow Turtle Cider:</b><br>
                                        Slow Turtle is a distinct cider product from Seychelles Breweries (Seybrew). It offers a sweet, crisp, and refreshing taste with notes of
                                        apple and pear, making it an ideal choice for the warm island climate. It's crafted to evoke a relaxed, "island life" feel and has
                                        an ABV of 5.5%.
                                    </p>
                                    <p><img src="<?php echo e(asset('images/operations-structure/seybre_imgs/slow_turtle_cider.jpg')); ?>" alt="seybrew_cider_logo" />
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseTwo">
                                    Soft Portfolio (SeyBrew Owned Product)
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingTwo"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify"><b>SeyPearl Soft:</b><br>
                                        SeyPearl is a popular local brand of soft drinks produced by Seybrew in Seychelles. This range offers a variety of refreshing
                                        non-alcoholic beverages, including carbonated soft drinks and potentially still drinks, catering to diverse tastes in the local market.
                                    </p>
                                    <p><img src="<?php echo e(asset('images/operations-structure/seybre_imgs/sey_pearl.png')); ?>" alt="seybrew_soft_logo" />
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="accordion-item white-accordion">
                            <h2 class="accordion-header" id="panelsStayOpen-headingFour">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#panelsStayOpen-collapseFour" aria-expanded="false"
                                    aria-controls="panelsStayOpen-collapseFour">
                                    Brands Under License
                                </button>
                            </h2>
                            <div id="panelsStayOpen-collapseFour" class="accordion-collapse collapse"
                                aria-labelledby="panelsStayOpen-headingFour"
                                data-bs-parent="#accordionPanelsStayOpenExample">
                                <div class="accordion-body">
                                    <p style="text-align: justify">Seybrew operates under license to bring several internationally renowned brands to the Seychelles market.
                                        In the beer category, this includes the iconic <b>Guinness</b> stout and the German lager <b>EKU</b>. For cider enthusiasts,
                                        Seybrew produces and distributes <b>Smirnoff Ice</b>. Furthermore, Seybrew holds the license for popular soft drink brands
                                        such as <b>Coca-Cola</b>, <b>Sprite</b>, and <b>Fanta</b>, ensuring these global favorites are readily available across the islands.
                                    </p>

                                </div>
                            </div>
                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var accordion = document.getElementById('accordionPanelsStayOpenExample');
        var seybrewContainer = document.querySelector('.seybrew-beer-container');

        // Function to update background
        function updateBackground(accordionId) {
            // Remove all background classes first
            seybrewContainer.classList.remove('bg-beer-portfolio', 'bg-cider-portfolio', 'bg-soft-portfolio', 'bg-brands-license');

            // Add appropriate background based on accordion
            switch(accordionId) {
                case 'panelsStayOpen-collapseTwenty':
                    seybrewContainer.classList.add('bg-beer-portfolio');
                    break;
                case 'panelsStayOpen-collapseEleven':
                    seybrewContainer.classList.add('bg-cider-portfolio');
                    break;
                case 'panelsStayOpen-collapseTwo':
                    seybrewContainer.classList.add('bg-soft-portfolio');
                    break;
                case 'panelsStayOpen-collapseFour':
                    seybrewContainer.classList.add('bg-brands-license');
                    break;
            }
        }

        // Handle accordion show event
        accordion.addEventListener('shown.bs.collapse', function(event) {
            var target = event.target;
            updateBackground(target.id);
        });

        // Handle accordion hide event
        accordion.addEventListener('hidden.bs.collapse', function(event) {
            // Check if any accordion is still open
            const openAccordions = document.querySelectorAll('.accordion-collapse.show');
            if (openAccordions.length === 0) {
                // Reset to default background when all accordions are closed
                seybrewContainer.classList.remove('bg-beer-portfolio', 'bg-cider-portfolio', 'bg-soft-portfolio', 'bg-brands-license');
            } else {
                // Update background for the remaining open accordion
                updateBackground(openAccordions[0].id);
            }
        });

        // Initialize background for the first open accordion
        const firstOpenAccordion = document.querySelector('.accordion-collapse.show');
        if (firstOpenAccordion) {
            updateBackground(firstOpenAccordion.id);
        }
    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/operation-structure/seybrew.blade.php ENDPATH**/ ?>