<style>
    .show-alert {
        display: flex;
        align-items: center;
        justify-content: flex-start;
        position: relative;
        padding: 8px;
        font-size: 1rem;
        border-radius: 5px;
        margin-bottom: 20px;
    }

    .show-alert .alert-icon {
        font-size: 1.5rem;
        margin-right: 10px;
        vertical-align: middle;
    }

    /* Alert message text */
    .show-alert .alert-text {
        display: inline-block;
        vertical-align: middle;
        font-size: 1rem;
    }

    /* Success style */
    .show-alert.success {
        color: #28a745;
        /* Green color */
    }

    /* Error style */
    .show-alert.error {
        color: #dc3545;
        /* Red color */
    }

    /* Form field wrapper for proper error message placement */
    .form-field-wrapper {
        margin-bottom: 15px;
        width: 100%;
    }
    
    .form-field-wrapper:last-child {
        margin-bottom: 0;
    }
    
    /* Error message styling */
    .error-message {
        color: #dc3545;
        font-size: 0.875rem;
        margin-top: 5px;
        display: none;
        line-height: 1.4;
    }
    
    .error-message:not(:empty) {
        display: block;
    }
    
    /* Invalid field styling */
    .form-control.is-invalid {
        border-color: #dc3545;
        padding-right: calc(1.5em + 0.75rem);
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 12 12' width='12' height='12' fill='none' stroke='%23dc3545'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath d='m5.8 3.6 .4.4.4-.4m0 4.8-.4-.4-.4.4'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right calc(0.375em + 0.1875rem) center;
        background-size: calc(0.75em + 0.375rem) calc(0.75em + 0.375rem);
    }
    
    .form-control.is-valid {
        border-color: #28a745;
    }
    
    /* Form Loader Styles */
    .form-loader {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-left: 15px;
    }
    
    .spinner-container {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        position: relative;
        width: 40px;
        height: 40px;
    }
    
    .spinner-ring {
        position: absolute;
        width: 100%;
        height: 100%;
        border: 3px solid transparent;
        border-top-color: #08BABB;
        border-radius: 50%;
        animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
    }
    
    .spinner-ring:nth-child(1) {
        animation-delay: -0.45s;
        border-top-color: #08BABB;
    }
    
    .spinner-ring:nth-child(2) {
        animation-delay: -0.3s;
        border-top-color: rgba(8, 186, 187, 0.7);
        width: 80%;
        height: 80%;
        top: 10%;
        left: 10%;
    }
    
    .spinner-ring:nth-child(3) {
        animation-delay: -0.15s;
        border-top-color: rgba(8, 186, 187, 0.5);
        width: 60%;
        height: 60%;
        top: 20%;
        left: 20%;
    }
    
    .spinner-ring:nth-child(4) {
        border-top-color: rgba(8, 186, 187, 0.3);
        width: 40%;
        height: 40%;
        top: 30%;
        left: 30%;
    }
    
    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }
        100% {
            transform: rotate(360deg);
        }
    }
    
    .loader-text {
        color: #08BABB;
        font-size: 0.9rem;
        font-weight: 500;
        white-space: nowrap;
    }
    
    /* Disable button during submission */
    #submit-button:disabled {
        opacity: 0.6;
        cursor: not-allowed;
    }

    /* Close button styling for the alert */
    .alert .close {
        font-size: 1.5rem;
        color: #000;
        background: transparent;
        border: none;
        padding: 0.5rem;
        cursor: pointer;
    }

    /* Honeypot field styling - completely hidden */
    .honeypot-field {
        position: absolute !important;
        left: -9999px !important;
        top: -9999px !important;
        width: 1px !important;
        height: 1px !important;
        opacity: 0 !important;
        pointer-events: none !important;
        z-index: -1 !important;
    }
</style>
<?php $__env->startSection('content'); ?>
    <div class="page-blue">
        <div class="about-banner contact-banner bg-image"
            style="background-image: url(<?php echo e(asset('images/Team-2-contact.jpg')); ?>);">
        </div>
        <div class="page-title-container">
            <h4>CONTACT US</h4>
            <span class="text-primary">Get in touch</span>
        </div>
    </div>

    <div class="container landing-section">
        <div class="row">
            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="<?php echo e($loop->index * 100); ?>">
                    <div class="contact-info-box contact-info-box-small mb-4">
                        <div class="country">
                            <h4 class="text-primary"> <?php echo e($contact['country'] ?? ''); ?></h4>
                        </div>
                        <div class="brand-name"><?php echo e($contact['name'] ?? ''); ?></div>
                        <div class="address"><span class="text-primary">Address: </span><?php echo e($contact['address'] ?? ''); ?>

                        </div>
                        <div class="email"><span class="text-primary">Email: </span><?php echo e($contact['email'] ?? ''); ?></div>
                        <div class="tel"><span class="text-primary">Tel: </span><?php echo e($contact['tel'] ?? ''); ?></div>
                        
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="col-12">
                <div class="contact-info-box contact-info-box-big smaller-text" data-aos="fade-up" data-aos-delay="1000">
                    <h4 class="text-primary">MOMENTS by PhoenixBev</h4>
                    <div class="" style="margin-left: 10px">
                        <div class="row">
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Pont Fer, Phoenix, Mauritius</div>
                                <div class="tel">Tel: +230 601 2083</div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: La Place Cap Tamarin, Mauritius
                                </div>
                                <div class="tel">Tel: +230 484 5206</div>
                            </div>
                        </div>
                        <div class="row mt-5">
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Shop A82-A83, Tribeca Mall, Ebène, Mauritius</div>
                                <div class="tel">Tel: +230 471 3009</div>
                            </div>
                            <div class="col-12 col-lg-6">
                                <div class="address">Address: Chemin Vingt Pieds, Grand Baie, Mauritius 30513</div>
                                <div class="tel">Tel: +230 268 2384</div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <br><br><br>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text mb-5">
                    <div class="country">
                        <h4 class="text-primary">Phoenix Shop</h4>
                        <div class="tel">Tel: +230 601 2171</div>
                    </div>

                    <br><br><br>

                    <div class="address"><span class="text-primary">Export Division</span></div>
                    <div class="tel">Tel: +230 601 2000</div>
                </div>
            </div>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text mb-5">
                    <div class="country">
                        <h4 class="text-primary">Public Relations</h4>
                    </div>
                    <div class="brand-name">Zethical Ltd</div>
                    <br>

                    <div class="address"><span class="text-primary">Address: </span>Port Louis, Mauritius</div>
                    <div class="email"><span class="text-primary">Email: </span> enquiries@zethical.com</div>
                    <div class="tel"><span class="text-primary">Tel: </span> +230 260 6050</div>
                </div>
            </div>
            <div class="col-12 col-lg-4" data-aos="fade-up" data-aos-delay="1000">
                <div class="contact-info-box contact-info-box-small smaller-text">
                    <div class="country">
                        <h4 class="text-primary">Customer Response Unit</h4>
                    </div>
                    <br><br>

                    <div class="tel"><span class="text-primary">Tel: </span> +230 601 2091</div>
                    <div class="tel"><span class="text-primary">Tel: </span> +230 601 2092</div>
                    
                </div>
            </div>

            <br><br><br>
        </div>

        <div class="row get-in-touch">
            <div class="col-12 col-lg-4 px-4" data-aos="fade-right" data-aos-delay="1000">
                <div class="text-primary">Get in touch</div>
                <h3>Write Us A Message</h3>
                <div class="contact-message" style="text-align: justify">
                    Do not hesistate to contact us if you require any further information. The contact details of
                    phoenix Beverages Group is available on this page,
                    you can give us a call or send us a message through our contact form.
                </div>
                &nbsp

                <div class="text-primary">Careers</div>
                <h3>Come in, find your seat</h3>
                <div class="contact-message" style="text-align: justify">
                    We nurture people who are generous in their
                    sharing of ideas and passionate about delivering quality to our customers and our consumers.

                    <div class="LearnMore">
                        <a href="<?php echo e(route('careers')); ?>" class="smallest-text">Explore more about our recruitment.</a>
                    </div>
                </div>
            </div>

            <div class="col-12 col-lg-8" data-aos="fade-left" data-aos-delay="1000">
                <form id="contact-form">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="form_start_time" value="<?php echo e(time()); ?>">
                    
                    <!-- Honeypot fields - hidden from users but visible to bots -->
                    <div class="honeypot-field" aria-hidden="true">
                        <input type="text" name="hp_website" tabindex="-1" autocomplete="nope">
                        <input type="text" name="hp_url" tabindex="-1" autocomplete="nope">
                        <input type="text" name="hp_company" tabindex="-1" autocomplete="nope">
                        <input type="text" name="hp_subject" tabindex="-1" autocomplete="nope">
                    </div>
                    
                    <div class="custom-form-group">
                        <div class="form-field-wrapper">
                            <input type="text" class="form-control" placeholder="Full Name" name="full_name"
                                value="<?php echo e(old('full_name')); ?>" required minlength="3" maxlength="50">
                            <div class="error-message" id="error-full_name"></div>
                            <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message" style="display: block;"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-field-wrapper">
                            <input type="email" class="form-control" placeholder="Email" name="email"
                                value="<?php echo e(old('email')); ?>" required>
                            <div class="error-message" id="error-email"></div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="error-message" style="display: block;"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="form-field-wrapper">
                        <textarea class="form-control" name="message" placeholder="Message" rows="7" required 
                            minlength="10" maxlength="1000"><?php echo e(old('message')); ?></textarea>
                        <div class="error-message" id="error-message"></div>
                        <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message" style="display: block;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="custom-form-group">
                        <div class="h-captcha" data-sitekey="<?php echo e(config('services.hcaptcha.secret')); ?>"></div>
                    </div>
                    <div class="cta d-flex align-items-center">
                        <input type="button" class="button pbg-button pbg-shadow" id="submit-button" value="Submit" />
                        <div id="loading-spinner" class="form-loader" style="display: none;">
                            <div class="spinner-container">
                                <div class="spinner-ring"></div>
                                <div class="spinner-ring"></div>
                                <div class="spinner-ring"></div>
                                <div class="spinner-ring"></div>
                            </div>
                            
                        </div>
                        <div class="show-alert" style="display: none">
                            <span class="alert-icon">&#x2714;</span>
                            <span class="alert-text text-smaller">Your submission was successful!</span>
                        </div>
                    </div>
                </form>
            </div>

        </div>

        <br><br><br>
        <h2>Locate us at</h2>
    </div>

    <div class="mt-5">
        <div class="map-container container-fluid">
            <iframe src="https://maps.google.com/maps?q=Pont Fer, Phoenix, 73544, Mauritius&amp;output=embed"></iframe>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<script src="<?php echo e(URL::asset('jquery/dist/jquery.js')); ?>"></script>
<script>
    var tpj = jQuery.noConflict();
    tpj(document).ready(function() {
        // Function to clear all error messages
        function clearErrorMessages() {
            tpj('.error-message').text('').hide();
            tpj('.form-control').removeClass('is-invalid is-valid');
        }
        
        // Function to show error message for a field
        function showFieldError(fieldName, message) {
            var errorElement = tpj('#error-' + fieldName);
            if (errorElement.length) {
                errorElement.text(message).show();
                tpj('[name="' + fieldName + '"]').addClass('is-invalid').removeClass('is-valid');
            }
        }
        
        // Function to clear error for a specific field
        function clearFieldError(fieldName) {
            var errorElement = tpj('#error-' + fieldName);
            if (errorElement.length) {
                errorElement.text('').hide();
                tpj('[name="' + fieldName + '"]').removeClass('is-invalid').addClass('is-valid');
            }
        }
        
        tpj("#contact-form").validate({
            rules: {
                full_name: {
                    required: true,
                    minlength: 3
                },
                email: {
                    required: true,
                    email: true
                },
                message: {
                    required: true,
                    minlength: 10
                }
            },
            messages: {
                full_name: {
                    required: "Please enter your name",
                    minlength: "Your name must be at least 3 characters long"
                },
                email: {
                    required: "Please enter your email",
                    email: "Please enter a valid email address"
                },
                message: {
                    required: "Please enter your message",
                    minlength: "Your message must be at least 10 characters long"
                }
            },
            errorPlacement: function(error, element) {
                var fieldName = element.attr('name');
                var errorMessage = error.text();
                showFieldError(fieldName, errorMessage);
                error.remove(); // Remove default error placement
            },
            success: function(label, element) {
                var fieldName = tpj(element).attr('name');
                clearFieldError(fieldName);
            },
            highlight: function(element) {
                tpj(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element) {
                tpj(element).removeClass('is-invalid').addClass('is-valid');
            }
        });

        tpj("#submit-button").on('click', function(event) {
            event.preventDefault();
            
            // Prevent rapid submissions
            if (tpj("#submit-button").prop('disabled')) {
                return;
            }
            
            // Clear previous error messages
            clearErrorMessages();
            
            // Validate form
            if (!tpj("#contact-form").valid()) {
                return;
            }
            
            // If validation passes, proceed with submission
            // Check if form was filled too quickly (less than 3 seconds)
            var formStartTime = tpj('input[name="form_start_time"]').val();
            var currentTime = Math.floor(Date.now() / 1000);
            var timeDiff = currentTime - formStartTime;
            
            if (timeDiff < 3) {
                tpj(".show-alert")
                    .removeClass("success")
                    .addClass("error")
                    .find(".alert-icon")
                    .html("&#10060;")
                    .end()
                    .find(".alert-text")
                    .text("Please take your time to fill out the form properly.")
                    .end()
                    .show();
                return;
            }

            var hcaptchaResponse = grecaptcha.getResponse();

            if (hcaptchaResponse === "") {
                tpj(".show-alert")
                    .removeClass("success")
                    .addClass("error")
                    .find(".alert-icon")
                    .html("&#10060;")
                    .end()
                    .find(".alert-text")
                    .text("Please complete the reCAPTCHA.")
                    .end()
                    .show();
                return;
            }

            // Disable button and show loader
            $("#submit-button").prop("disabled", true);
            $("#loading-spinner").fadeIn(300);

            $.ajax({
                url: "<?php echo e(route('send.email')); ?>",
                method: "POST",
                data: tpj("#contact-form").serialize() + "&h-recaptcha-response=" + hcaptchaResponse,
                success: function(response) {
                    $("#loading-spinner").fadeOut(300);
                    clearErrorMessages();
                    if (response.status === 'success') {
                        const caseId = response.data;
                        tpj(".show-alert")
                            .removeClass("error")
                            .addClass("success")
                            .find(".alert-icon")
                            .html("&#x2714;")
                            .end()
                            .find(".alert-text")
                            .text(`Your submission was successful! case id : ${caseId} `)
                            .end()
                            .show();
                    } else {
                        $(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    }

                    tpj("#contact-form")[0].reset();
                    grecaptcha.reset();
                },
                error: function(xhr, status, error) {
                    tpj("#loading-spinner").fadeOut(300);
                    clearErrorMessages();
                    
                    // Handle validation errors from Laravel
                    if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                        var errors = xhr.responseJSON.errors;
                        tpj.each(errors, function(field, messages) {
                            if (messages && messages.length > 0) {
                                showFieldError(field, messages[0]);
                            }
                        });
                        
                        // Show general error message
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Please correct the errors in the form.")
                            .end()
                            .show();
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        // Show specific error message from server
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text(xhr.responseJSON.message)
                            .end()
                            .show();
                    } else {
                        // Generic error
                        tpj(".show-alert")
                            .removeClass("success")
                            .addClass("error")
                            .find(".alert-icon")
                            .html("&#10060;")
                            .end()
                            .find(".alert-text")
                            .text("Something went wrong, please try again later.")
                            .end()
                            .show();
                    }
                },
                complete: function() {
                    $("#submit-button").prop("disabled", false);
                }
            });
        });
    });


    tpj(document).on('click', '.alert .close', function() {
        tpj(this).parent().hide();
    });
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/contact-us.blade.php ENDPATH**/ ?>