<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            <h2>Spam Monitoring Dashboard</h2>
            <p class="text-muted">Monitor and manage spam attempts on your forms</p>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="card-title">Total Attempts</h5>
                    <h3><?php echo e($stats['total_attempts'] ?? 0); ?></h3>
                    <small>Last <?php echo e($days); ?> days</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">Blocked Attempts</h5>
                    <h3><?php echo e($stats['blocked_attempts'] ?? 0); ?></h3>
                    <small>Successfully blocked</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h5 class="card-title">Contact Form</h5>
                    <h3><?php echo e($stats['by_form']['contact'] ?? 0); ?></h3>
                    <small>Spam attempts</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <h5 class="card-title">Career Form</h5>
                    <h3><?php echo e($stats['by_form']['career'] ?? 0); ?></h3>
                    <small>Spam attempts</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Spam Type Breakdown -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Spam Types (Last <?php echo e($days); ?> days)</h5>
                </div>
                <div class="card-body">
                    <?php if(isset($stats['by_type']) && count($stats['by_type']) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Count</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $stats['by_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php switch($type):
                                                case ('honeypot'): ?>
                                                    <span class="badge bg-danger">Honeypot</span>
                                                    <?php break; ?>
                                                <?php case ('timing'): ?>
                                                    <span class="badge bg-warning">Timing</span>
                                                    <?php break; ?>
                                                <?php case ('keywords'): ?>
                                                    <span class="badge bg-info">Keywords</span>
                                                    <?php break; ?>
                                                <?php case ('patterns'): ?>
                                                    <span class="badge bg-secondary">Patterns</span>
                                                    <?php break; ?>
                                                <?php case ('ip_reputation'): ?>
                                                    <span class="badge bg-dark">IP Reputation</span>
                                                    <?php break; ?>
                                                <?php default: ?>
                                                    <span class="badge bg-light text-dark"><?php echo e(ucfirst($type)); ?></span>
                                            <?php endswitch; ?>
                                        </td>
                                        <td><?php echo e($count); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No spam attempts recorded in the last <?php echo e($days); ?> days.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5>Top Spam IPs (Last <?php echo e($days); ?> days)</h5>
                </div>
                <div class="card-body">
                    <?php if(count($topSpamIps) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>IP Address</th>
                                        <th>Attempts</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $topSpamIps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><code><?php echo e($ip->ip_address); ?></code></td>
                                        <td><?php echo e($ip->attempt_count); ?></td>
                                        <td>
                                            <button class="btn btn-sm btn-danger block-ip" data-ip="<?php echo e($ip->ip_address); ?>">
                                                Block IP
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No spam IPs recorded in the last <?php echo e($days); ?> days.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Attempts -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Recent Spam Attempts</h5>
                    <div>
                        <button class="btn btn-sm btn-outline-danger" id="clear-old-attempts">
                            Clear Old Attempts
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(count($recentAttempts) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Date/Time</th>
                                        <th>IP Address</th>
                                        <th>Form Type</th>
                                        <th>Spam Type</th>
                                        <th>Details</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $recentAttempts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($attempt->created_at->format('Y-m-d H:i:s')); ?></td>
                                        <td><code><?php echo e($attempt->ip_address); ?></code></td>
                                        <td>
                                            <?php if($attempt->form_type === 'contact'): ?>
                                                <span class="badge bg-primary">Contact</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning">Career</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php switch($attempt->spam_type):
                                                case ('honeypot'): ?>
                                                    <span class="badge bg-danger">Honeypot</span>
                                                    <?php break; ?>
                                                <?php case ('timing'): ?>
                                                    <span class="badge bg-warning">Timing</span>
                                                    <?php break; ?>
                                                <?php case ('keywords'): ?>
                                                    <span class="badge bg-info">Keywords</span>
                                                    <?php break; ?>
                                                <?php case ('patterns'): ?>
                                                    <span class="badge bg-secondary">Patterns</span>
                                                    <?php break; ?>
                                                <?php case ('ip_reputation'): ?>
                                                    <span class="badge bg-dark">IP Reputation</span>
                                                    <?php break; ?>
                                                <?php default: ?>
                                                    <span class="badge bg-light text-dark"><?php echo e(ucfirst($attempt->spam_type)); ?></span>
                                            <?php endswitch; ?>
                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo e(Str::limit($attempt->details, 50)); ?></small>
                                        </td>
                                        <td>
                                            <?php if($attempt->blocked): ?>
                                                <span class="badge bg-success">Blocked</span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Detected</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No recent spam attempts found.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Block IP functionality
    document.querySelectorAll('.block-ip').forEach(button => {
        button.addEventListener('click', function() {
            const ip = this.dataset.ip;
            if (confirm(`Are you sure you want to block IP ${ip}?`)) {
                fetch('<?php echo e(route("admin.spam.block-ip")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ ip: ip })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert(data.message);
                        location.reload();
                    } else {
                        alert('Error: ' + data.error);
                    }
                });
            }
        });
    });

    // Clear old attempts
    document.getElementById('clear-old-attempts').addEventListener('click', function() {
        if (confirm('Are you sure you want to clear old spam attempts? This action cannot be undone.')) {
            fetch('<?php echo e(route("admin.spam.clear-old")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({ days: 30 })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert(data.message);
                    location.reload();
                } else {
                    alert('Error: ' + data.error);
                }
            });
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/plrgpimy/public_html/enhanced_pbg/resources/views/admin/spam-monitoring.blade.php ENDPATH**/ ?>